/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tenancy;

import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.tenancy.JiraTenantAccessor;
import com.atlassian.jira.tenancy.JiraTenantImpl;
import com.atlassian.jira.tenancy.TenancyCondition;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.google.common.annotations.VisibleForTesting;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantPluginBridge
implements InitializingComponent {
    private volatile boolean triggered;
    private volatile boolean started;
    private final SplitStartupPluginSystemLifecycle pluginManager;
    private final ApplicationProperties applicationProperties;
    private final TenancyCondition tenancyCondition;
    private final JiraTenantAccessor jiraTenantAccessor;
    private static final Logger log = LoggerFactory.getLogger(TenantPluginBridge.class);

    public TenantPluginBridge(SplitStartupPluginSystemLifecycle pluginManager, ApplicationProperties applicationProperties, TenancyCondition tenancyCondition, JiraTenantAccessor jiraTenantAccessor) {
        this.pluginManager = pluginManager;
        this.applicationProperties = applicationProperties;
        this.tenancyCondition = tenancyCondition;
        this.jiraTenantAccessor = jiraTenantAccessor;
    }

    public void trigger() {
        this.triggered = true;
        this.startPhase2IfTenanted();
    }

    public void start() {
        this.started = true;
        this.startPhase2IfTenanted();
    }

    private void startPhase2IfTenanted() {
        if (this.triggered && this.started) {
            this.pluginManager.lateStartup();
        }
    }

    @Override
    public void afterInstantiation() throws Exception {
        String baseUrl = this.applicationProperties.getDefaultBackedText("jira.baseurl");
        if (!this.tenancyCondition.isEnabled()) {
            this.triggered = true;
        } else if (baseUrl != null) {
            this.triggered = true;
            this.jiraTenantAccessor.addTenant(new JiraTenantImpl(this.getBaseUrlWithoutProtocol(baseUrl)));
        }
    }

    private String getBaseUrlWithoutProtocol(String baseUrl) {
        try {
            URL url = new URL(baseUrl);
            return url.getAuthority() + url.getPath();
        }
        catch (Exception e) {
            return baseUrl;
        }
    }

    @VisibleForTesting
    boolean isTriggered() {
        return this.triggered;
    }
}

