/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.appconsistency.clustering.ClusterLicenseCheck;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.startup.JiraClusteringConfigChecklist;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringChecklistLauncher
implements JiraLauncher {
    private static final Logger log = LoggerFactory.getLogger(ClusteringChecklistLauncher.class);
    private final JohnsonProvider johnsonProvider;

    public ClusteringChecklistLauncher(JohnsonProvider johnsonProvider) {
        this.johnsonProvider = johnsonProvider;
    }

    @Override
    public void start() {
        ApplicationProperties applicationProperties;
        JiraHome jiraHome;
        I18nHelper i18nHelper;
        ClusterNodeProperties clusterNodeProperties;
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponentOfType(ClusterManager.class);
        JiraClusteringConfigChecklist jiraClusteringConfigChecklist = new JiraClusteringConfigChecklist(clusterManager, clusterNodeProperties = (ClusterNodeProperties)ComponentAccessor.getComponentOfType(ClusterNodeProperties.class), i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance((ApplicationUser)null), jiraHome = (JiraHome)ComponentAccessor.getComponentOfType(JiraHome.class), applicationProperties = ComponentAccessor.getApplicationProperties());
        if (jiraClusteringConfigChecklist.startupOK()) {
            log.info("JIRA clustering startup checks completed successfully.");
        } else {
            List<StartupCheck> failedChecks = jiraClusteringConfigChecklist.getFailedStartupChecks();
            for (StartupCheck failedCheck : failedChecks) {
                this.raiseJohnson(failedCheck);
            }
        }
    }

    private void raiseJohnson(StartupCheck failedCheck) {
        String desc = failedCheck.getFaultDescription();
        log.error(failedCheck.getName() + " failed: " + desc);
        log.error("Clustering startup check failed.");
        EventType eventType = failedCheck instanceof ClusterLicenseCheck ? EventType.get((String)"clustering-unlicensed") : EventType.get((String)"clustering");
        Event event = new Event(eventType, failedCheck.getHTMLFaultDescription(), EventLevel.get((String)"error"));
        this.johnsonProvider.getContainer().addEvent(event);
    }

    @Override
    public void stop() {
    }
}

