/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IndexingStrategy;
import com.atlassian.jira.index.MultiThreadedIndexingConfiguration;
import com.atlassian.jira.index.MultiThreadedIndexingStrategy;
import com.atlassian.jira.index.SimpleIndexingStrategy;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultSharedEntityIndexManager
implements SharedEntityIndexManager {
    private final SharedEntityIndexer indexer;
    private final FileFactory fileFactory;
    private final MultiThreadedIndexingConfiguration multiThreadedIndexingConfiguration;
    private final IndexingStrategy simpleIndexingStrategy = new SimpleIndexingStrategy();
    private final SharedEntity.TypeDescriptor<?>[] types = new SharedEntity.TypeDescriptor[]{SearchRequest.ENTITY_TYPE, PortalPage.ENTITY_TYPE};
    private final Map<SharedEntity.TypeDescriptor<?>, Retriever<? extends SharedEntity>> retrievers;

    public DefaultSharedEntityIndexManager(SharedEntityIndexer indexer, SearchRequestManager searchRequestManager, PortalPageManager portalPageManager, FileFactory fileFactory, ApplicationProperties applicationProperties) {
        this.indexer = indexer;
        this.fileFactory = fileFactory;
        LinkedHashMap retrievers = new LinkedHashMap(this.types.length);
        retrievers.put(SearchRequest.ENTITY_TYPE, () -> searchRequestManager.getAllIndexableSharedEntities());
        retrievers.put(PortalPage.ENTITY_TYPE, () -> portalPageManager.getAllIndexableSharedEntities());
        this.retrievers = Collections.unmodifiableMap(retrievers);
        this.multiThreadedIndexingConfiguration = new PropertiesAdapter(applicationProperties);
    }

    public long reIndexAll(Context context) {
        return this.reIndexAll(context, null);
    }

    public long reIndexAll(Context context, IssueIndexingParams issueIndexingParams) {
        Assertions.notNull((String)"event", (Object)context);
        long result = 0L;
        for (Map.Entry<SharedEntity.TypeDescriptor<?>, Retriever<SharedEntity>> entry : this.retrievers.entrySet()) {
            this.indexer.recreate(entry.getKey());
            result += this.reIndex(context, entry.getKey(), entry.getValue());
        }
        return result;
    }

    @Override
    public long reIndexSharedEntities(@Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams, @Nonnull Set<SharedEntity.TypeDescriptor> sharedEntityTypes) {
        Assertions.notNull((String)"context", (Object)context);
        Assertions.notNull((String)"issueIndexingParams", (Object)issueIndexingParams);
        Assertions.notNull((String)"sharedEntityTypes", sharedEntityTypes);
        long result = 0L;
        for (SharedEntity.TypeDescriptor sharedEntityType : sharedEntityTypes) {
            Retriever<? extends SharedEntity> retriever = this.retrievers.get(sharedEntityType);
            if (retriever == null) {
                throw new IllegalArgumentException("Unknown shared entity type: " + sharedEntityType);
            }
            this.indexer.recreate(sharedEntityType);
            result += this.reIndex(context, sharedEntityType, retriever);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S extends SharedEntity> long reIndex(final Context context, SharedEntity.TypeDescriptor<?> type, Retriever<S> retriever) {
        context.setName(type.getName());
        long start = System.currentTimeMillis();
        EnclosedIterable<S> all = retriever.getAll();
        try (final IndexingStrategy strategy = this.getStrategy(all.size());){
            final AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
            all.foreach(new Consumer<S>(){

                public void consume(final S entity) {
                    final Context.Task task = context.start(entity);
                    builder.add(entity.getEntityType().getName(), entity.getId(), (Index.Result)strategy.get(new Supplier<Index.Result>(){

                        public Index.Result get() {
                            try {
                                Index.Result result = DefaultSharedEntityIndexManager.this.indexer.index(entity, false);
                                return result;
                            }
                            finally {
                                task.complete();
                            }
                        }
                    }));
                }
            });
            builder.toResult().await();
            long l = System.currentTimeMillis() - start;
            return l;
        }
    }

    private <S> IndexingStrategy getStrategy(int count) {
        if (count < this.multiThreadedIndexingConfiguration.minimumBatchSize()) {
            return this.simpleIndexingStrategy;
        }
        return new MultiThreadedIndexingStrategy(this.simpleIndexingStrategy, this.multiThreadedIndexingConfiguration, "SharedEntityIndexer");
    }

    public long reIndexAll() throws IndexException {
        return this.reIndexAll(Contexts.nullContext());
    }

    public long reIndexAllIssuesInBackground(Context context) {
        return this.reIndexAll(context);
    }

    public long reIndexAllIssuesInBackground(Context context, boolean reIndexComments, boolean reIndexChangeHistory) {
        return this.reIndexAll(context);
    }

    public long reIndexIssuesInBackground(Context context, IssueIndexingParams issueIndexingParams) {
        return this.reIndexAll(context);
    }

    public long optimize() {
        long result = 0L;
        for (SharedEntity.TypeDescriptor<?> type : this.types) {
            result += this.indexer.optimize(type);
        }
        return result;
    }

    public void shutdown() {
        for (SharedEntity.TypeDescriptor<?> type : this.types) {
            this.indexer.shutdown(type);
        }
    }

    public long activate(Context context, boolean reindex) {
        if (reindex) {
            return this.activate(context);
        }
        return 0L;
    }

    public long activate(Context context) {
        Assertions.notNull((String)"event", (Object)context);
        return this.reIndexAll(context);
    }

    public void deactivate() {
        for (SharedEntity.TypeDescriptor<?> type : this.types) {
            this.clear(type);
        }
    }

    public boolean isIndexingEnabled() {
        return true;
    }

    public boolean isIndexAvailable() {
        return true;
    }

    public boolean isIndexConsistent() {
        return true;
    }

    public Collection<String> getAllIndexPaths() {
        return this.indexer.getAllIndexPaths();
    }

    public int size() {
        return this.sum(this.sizes());
    }

    public boolean isEmpty() {
        for (Retriever<? extends SharedEntity> element : this.retrievers.values()) {
            if (element.getAll().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private int sum(int[] ints) {
        int result = 0;
        for (int j : ints) {
            result += j;
        }
        return result;
    }

    private int[] sizes() {
        int[] sizes = new int[this.retrievers.size()];
        int i = 0;
        for (Retriever<? extends SharedEntity> element : this.retrievers.values()) {
            sizes[i++] = element.getAll().size();
        }
        return sizes;
    }

    public String toString() {
        return "SharedEntityIndexManager: paths: " + this.getAllIndexPaths();
    }

    private void clear(SharedEntity.TypeDescriptor<?> type) {
        this.fileFactory.removeDirectoryIfExists(this.indexer.clear(type));
    }

    static class PropertiesAdapter
    implements MultiThreadedIndexingConfiguration {
        private final ApplicationProperties applicationProperties;

        PropertiesAdapter(ApplicationProperties applicationProperties) {
            this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        }

        @Override
        public int minimumBatchSize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.sharedentity.minbatchsize", (int)50);
        }

        @Override
        public int maximumQueueSize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.sharedentity.maxqueuesize", (int)1000);
        }

        @Override
        public int noOfThreads() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.sharedentity.threads", (int)10);
        }
    }

    static interface Retriever<S extends SharedEntity> {
        public EnclosedIterable<S> getAll();
    }
}

