/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.cluster;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.jira.cluster.OfBizClusterMessageStore;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.service.AbstractService;
import com.atlassian.jira.util.JiraDurationUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMessageCleaningService
extends AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMessageCleaningService.class);
    public static final String RETENTION_PERIOD = "RETENTION_PERIOD";
    private final OfBizClusterMessageStore ofBizClusterMessageStore;
    private final JiraDurationUtils jiraDurationUtils;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private long retentionPeriod;

    public ClusterMessageCleaningService(OfBizClusterMessageStore ofBizClusterMessageStore, JiraDurationUtils jiraDurationUtils, JiraAuthenticationContext jiraAuthenticationContext) {
        this.ofBizClusterMessageStore = ofBizClusterMessageStore;
        this.jiraDurationUtils = jiraDurationUtils;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        if (this.hasProperty(RETENTION_PERIOD)) {
            String retention = this.getProperty(RETENTION_PERIOD);
            try {
                this.retentionPeriod = this.jiraDurationUtils.parseDuration(retention, this.jiraAuthenticationContext.getLocale());
            }
            catch (InvalidDurationException e) {
                LOGGER.error("Invalid Duration specified in service configuration", (Throwable)e);
            }
        }
    }

    public void run() {
        Date deleteBeforeTime = new Date(new Date().getTime() - this.retentionPeriod * 1000L);
        this.ofBizClusterMessageStore.deleteMessagesBefore(deleteBeforeTime);
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("INDEXCLEANERSERVICE", "services/com/atlassian/jira/service/services/index/indexcleanerservice.xml", null);
    }

    public long getRetentionPeriod() {
        return this.retentionPeriod;
    }
}

