/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.DefaultRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleComparator;
import com.atlassian.jira.security.roles.ProjectRoleImpl;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizProjectRoleAndActorStore
implements ProjectRoleAndActorStore {
    private static final Logger log = LoggerFactory.getLogger(OfBizProjectRoleAndActorStore.class);
    private static final String ENTITY_NAME = "ProjectRole";
    private final OfBizDelegator ofBizDelegator;
    private final RoleActorFactory roleActorFactory;
    private final GroupManager groupManager;
    private static final String PROJECT_ROLE_FIELD_NAME = "name";
    private static final String PROJECT_ROLE_FIELD_DESCRIPTION = "description";
    private static final String ROLE_ACTOR_PID = "pid";
    private static final String FIELD_ID = "id";
    private static final String ROLE_ACTOR_ROLETYPE = "roletype";
    private static final String ROLE_ACTOR_TYPE = "roletype";
    private static final String ROLE_ACTOR_PARAMETER = "roletypeparameter";
    private static final String ROLE_ACTOR_PROJECTROLEID = "projectroleid";
    private static final String ROLE_ACTOR_ENTITY_NAME = "ProjectRoleActor";

    public OfBizProjectRoleAndActorStore(OfBizDelegator genericDelegator, RoleActorFactory roleActorFactory, GroupManager groupManager) {
        this.ofBizDelegator = genericDelegator;
        this.roleActorFactory = roleActorFactory;
        this.groupManager = groupManager;
    }

    @Override
    public ProjectRole addProjectRole(ProjectRole projectRole) {
        try {
            GenericValue projectRoleGV = EntityUtils.createValue(ENTITY_NAME, MapBuilder.build((Object)PROJECT_ROLE_FIELD_NAME, (Object)projectRole.getName(), (Object)PROJECT_ROLE_FIELD_DESCRIPTION, (Object)projectRole.getDescription()));
            return new ProjectRoleImpl(projectRoleGV.getLong(FIELD_ID), projectRoleGV.getString(PROJECT_ROLE_FIELD_NAME), projectRoleGV.getString(PROJECT_ROLE_FIELD_DESCRIPTION));
        }
        catch (Exception e) {
            log.error("Unable to store project role, removing any partially stored entity: " + projectRole.getName(), (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public void updateProjectRole(ProjectRole projectRole) {
        try {
            GenericValue projectRoleGv = this.ofBizDelegator.findById(ENTITY_NAME, projectRole.getId());
            projectRoleGv.set(PROJECT_ROLE_FIELD_NAME, (Object)projectRole.getName());
            projectRoleGv.set(PROJECT_ROLE_FIELD_DESCRIPTION, (Object)projectRole.getDescription());
            projectRoleGv.store();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public Collection<ProjectRole> getAllProjectRoles() {
        try {
            List projectRoleGVs = this.ofBizDelegator.findAll(ENTITY_NAME, (List)ImmutableList.of((Object)"name ASC"));
            TreeSet<ProjectRole> projectRoles = new TreeSet<ProjectRole>(ProjectRoleComparator.COMPARATOR);
            for (GenericValue projectRoleGV : projectRoleGVs) {
                projectRoles.add(this.convertProjectRoleGVToProjectRoleObject(projectRoleGV));
            }
            return projectRoles;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public ProjectRole getProjectRole(Long id) {
        try {
            UtilTimerStack.push((String)"OfBizProjectRoleAndActorStore.getProjectRole");
            GenericValue projectRoleGV = this.ofBizDelegator.findById(ENTITY_NAME, id);
            ProjectRole projectRole = this.convertProjectRoleGVToProjectRoleObject(projectRoleGV);
            return projectRole;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            UtilTimerStack.pop((String)"OfBizProjectRoleAndActorStore.getProjectRole");
        }
    }

    @Override
    public ProjectRole getProjectRoleByName(String name) {
        try {
            UtilTimerStack.push((String)"OfBizProjectRoleAndActorStore.getProjectRoleByName");
            List projectRolesGV = this.ofBizDelegator.findByAnd(ENTITY_NAME, (Map)FieldMap.build((String)PROJECT_ROLE_FIELD_NAME, (Object)name));
            if (projectRolesGV.size() == 1) {
                GenericValue projectRoleGV = (GenericValue)projectRolesGV.get(0);
                ProjectRole projectRole = this.convertProjectRoleGVToProjectRoleObject(projectRoleGV);
                return projectRole;
            }
            if (projectRolesGV.size() > 1) {
                log.error("You have more than one ProjectRole with name " + name);
                throw new DataAccessException("You have more than one ProjectRole with name " + name);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        finally {
            UtilTimerStack.pop((String)"OfBizProjectRoleAndActorStore.getProjectRoleByName");
        }
        return null;
    }

    @Override
    public void deleteProjectRole(ProjectRole projectRole) {
        try {
            GenericValue projectRoleGV = this.ofBizDelegator.findById(ENTITY_NAME, projectRole.getId());
            projectRoleGV.removeRelated("ChildProjectRoleActor");
            this.ofBizDelegator.removeValue(projectRoleGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @Override
    public ProjectRoleActors getProjectRoleActors(Long projectRoleId, Long projectId) {
        Set<ProjectRoleActor> actors = this.getRoleActors(projectId, projectRoleId);
        return new ProjectRoleActorsImpl(projectId, projectRoleId, actors);
    }

    @Override
    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) {
        this.updateRoleActors((DefaultRoleActors)projectRoleActors, projectRoleActors.getProjectId());
    }

    @Override
    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) {
        this.updateRoleActors(defaultRoleActors, null);
    }

    @Override
    public DefaultRoleActors getDefaultRoleActors(Long projectRoleId) {
        Set<ProjectRoleActor> actors = this.getRoleActors(null, projectRoleId);
        return new DefaultRoleActorsImpl(projectRoleId, actors);
    }

    @Override
    public void applyDefaultsRolesToProject(Project project) {
        Collection<ProjectRole> projectRoles = this.getAllProjectRoles();
        for (ProjectRole projectRole : projectRoles) {
            Set<ProjectRoleActor> roleActors = this.getRoleActors(null, projectRole.getId());
            for (RoleActor roleActor : roleActors) {
                EntityUtils.createValue(ROLE_ACTOR_ENTITY_NAME, (Map<String, Object>)FieldMap.build((String)ROLE_ACTOR_PID, (Object)project.getId(), (String)ROLE_ACTOR_PROJECTROLEID, (Object)projectRole.getId(), (String)"roletype", (Object)roleActor.getType(), (String)ROLE_ACTOR_PARAMETER, (Object)roleActor.getParameter()));
            }
        }
    }

    @Override
    public void removeAllRoleActorsByKeyAndType(String key, String type) {
        this.ofBizDelegator.removeByAnd(ROLE_ACTOR_ENTITY_NAME, (Map)FieldMap.build((String)ROLE_ACTOR_PARAMETER, (Object)key, (String)"roletype", (Object)type));
    }

    @Override
    public void removeAllRoleActorsByProject(Project project) {
        this.ofBizDelegator.removeByAnd(ROLE_ACTOR_ENTITY_NAME, (Map)FieldMap.build((String)ROLE_ACTOR_PID, (Object)project.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> getProjectIdsContainingRoleActorByKeyAndType(String key, String type) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        try (OfBizListIterator listIterator = null;){
            EntityFieldMap condition = new EntityFieldMap((Map)FieldMap.build((String)ROLE_ACTOR_PARAMETER, (Object)key, (String)"roletype", (Object)type), EntityOperator.AND);
            EntityFindOptions findOptions = new EntityFindOptions();
            findOptions.setDistinct(true);
            listIterator = this.ofBizDelegator.findListIteratorByCondition(ROLE_ACTOR_ENTITY_NAME, (EntityCondition)condition, null, (Collection)ImmutableList.of((Object)ROLE_ACTOR_PID), null, findOptions);
            GenericValue projectIdGV = listIterator.next();
            while (projectIdGV != null) {
                projectIds.add(projectIdGV.getLong(ROLE_ACTOR_PID));
                projectIdGV = listIterator.next();
            }
        }
        return projectIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) {
        try (OfBizListIterator listIterator = null;){
            EntityExpr projectIdsClause = new EntityExpr(ROLE_ACTOR_PID, EntityOperator.IN, projectsToLimitBy);
            EntityFieldMap otherClause = new EntityFieldMap((Map)FieldMap.build((String)ROLE_ACTOR_PARAMETER, (Object)projectRoleParameter, (String)"roletype", (Object)projectRoleType, (String)ROLE_ACTOR_PROJECTROLEID, (Object)projectRole.getId()), EntityOperator.AND);
            EntityExpr condition = new EntityExpr((EntityCondition)otherClause, EntityOperator.AND, (EntityCondition)projectIdsClause);
            EntityFindOptions findOptions = new EntityFindOptions();
            findOptions.setDistinct(true);
            listIterator = this.ofBizDelegator.findListIteratorByCondition(ROLE_ACTOR_ENTITY_NAME, (EntityCondition)condition, null, (Collection)ImmutableList.of((Object)ROLE_ACTOR_PID), null, findOptions);
            GenericValue projectIdGV = listIterator.next();
            ArrayList<Long> projectsIn = new ArrayList<Long>();
            while (projectIdGV != null) {
                projectsIn.add(projectIdGV.getLong(ROLE_ACTOR_PID));
                projectIdGV = listIterator.next();
            }
            ArrayList<Long> arrayList = projectsIn;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userKey) {
        MultiMap groupNamesUserInForProjects = MultiMaps.create((Supplier)new Supplier<List<String>>(){

            public List<String> get() {
                return new ArrayList<String>();
            }
        });
        EntityExpr projectIdsClause = new EntityExpr(ROLE_ACTOR_PID, EntityOperator.IN, projectsToLimitBy);
        ApplicationUser user = this.getUser(userKey);
        if (user != null) {
            List groups;
            ArrayList allGroups = new ArrayList(this.groupManager.getGroupNamesForUser(user));
            int queryBatchSize = DefaultOfBizDelegator.getQueryBatchSize();
            for (int index = 0; index < allGroups.size(); index += groups.size()) {
                groups = this.getSafeSublist(allGroups, index, queryBatchSize + index);
                EntityExpr groupNamesClause = new EntityExpr(ROLE_ACTOR_PARAMETER, EntityOperator.IN, groups);
                EntityFieldMap otherClause = new EntityFieldMap(MapBuilder.build((Object)"roletype", (Object)projectRoleType, (Object)ROLE_ACTOR_PROJECTROLEID, (Object)projectRole.getId()), EntityOperator.AND);
                EntityExpr mainClaus = new EntityExpr((EntityCondition)otherClause, EntityOperator.AND, (EntityCondition)groupNamesClause);
                EntityExpr condition = projectsToLimitBy.isEmpty() ? mainClaus : new EntityExpr((EntityCondition)mainClaus, EntityOperator.AND, (EntityCondition)projectIdsClause);
                EntityFindOptions findOptions = new EntityFindOptions();
                findOptions.setDistinct(true);
                try (OfBizListIterator listIterator = this.ofBizDelegator.findListIteratorByCondition(ROLE_ACTOR_ENTITY_NAME, (EntityCondition)condition, null, Arrays.asList(ROLE_ACTOR_PID, ROLE_ACTOR_PARAMETER), null, findOptions);){
                    GenericValue projectIdGV = listIterator.next();
                    while (projectIdGV != null) {
                        groupNamesUserInForProjects.putSingle((Object)projectIdGV.getLong(ROLE_ACTOR_PID), (Object)projectIdGV.getString(ROLE_ACTOR_PARAMETER));
                        projectIdGV = listIterator.next();
                    }
                    continue;
                }
            }
            return groupNamesUserInForProjects;
        }
        log.error("Unable to find user with name: " + userKey);
        throw new IllegalArgumentException("Unable to find user with name: " + userKey);
    }

    private <T> List<T> getSafeSublist(List<T> originalList, int start, int end) {
        if (start > originalList.size()) {
            return Collections.emptyList();
        }
        if (end > originalList.size()) {
            end = originalList.size();
        }
        return originalList.subList(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ProjectRoleActor> getRoleActors(Long projectId, Long projectRoleId) {
        try {
            UtilTimerStack.push((String)"OfBizProjectRoleAndActorStore.getRoleActors");
            HashSet<ProjectRoleActor> actors = new HashSet<ProjectRoleActor>();
            List actorGVs = this.ofBizDelegator.findByAnd(ROLE_ACTOR_ENTITY_NAME, MapBuilder.build((Object)ROLE_ACTOR_PROJECTROLEID, (Object)projectRoleId, (Object)ROLE_ACTOR_PID, (Object)projectId));
            for (GenericValue actorGV : actorGVs) {
                try {
                    ProjectRoleActor actor = this.roleActorFactory.createRoleActor(actorGV.getLong(FIELD_ID), projectRoleId, projectId, actorGV.getString("roletype"), actorGV.getString(ROLE_ACTOR_PARAMETER));
                    actors.add(actor);
                }
                catch (IllegalArgumentException iae) {
                    log.warn("Unable to create a project role actor for type '" + actorGV.getString("roletype") + "'. " + iae.getMessage());
                }
                catch (RoleActorDoesNotExistException ex) {
                    log.warn("Unable to create a project role actor. " + ex.getMessage());
                }
            }
            HashSet<ProjectRoleActor> hashSet = actors;
            return hashSet;
        }
        finally {
            UtilTimerStack.pop((String)"OfBizProjectRoleAndActorStore.getRoleActors");
        }
    }

    private void updateRoleActors(DefaultRoleActors projectRoleActors, Long projectId) {
        try {
            Set<ProjectRoleActor> existingActors = this.getRoleActors(projectId, projectRoleActors.getProjectRoleId());
            HashSet actorsToAdd = new HashSet(projectRoleActors.getRoleActors());
            HashSet<ProjectRoleActor> actorsToRemove = new HashSet<ProjectRoleActor>(existingActors);
            actorsToRemove.removeAll(actorsToAdd);
            actorsToAdd.removeAll(existingActors);
            if (!actorsToRemove.isEmpty()) {
                ArrayList<Long> ids = new ArrayList<Long>();
                for (RoleActor roleActor : actorsToRemove) {
                    ids.add(roleActor.getId());
                }
                this.ofBizDelegator.removeByOr(ROLE_ACTOR_ENTITY_NAME, FIELD_ID, ids);
            }
            for (RoleActor roleActor : actorsToAdd) {
                EntityUtils.createValue(ROLE_ACTOR_ENTITY_NAME, MapBuilder.build((Object)ROLE_ACTOR_PID, (Object)projectId, (Object)ROLE_ACTOR_PROJECTROLEID, (Object)projectRoleActors.getProjectRoleId(), (Object)"roletype", (Object)roleActor.getType(), (Object)ROLE_ACTOR_PARAMETER, (Object)roleActor.getParameter()));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private ProjectRole convertProjectRoleGVToProjectRoleObject(GenericValue projectRoleGV) throws GenericEntityException {
        ProjectRoleImpl role = null;
        if (projectRoleGV != null) {
            role = new ProjectRoleImpl(projectRoleGV.getLong(FIELD_ID), projectRoleGV.getString(PROJECT_ROLE_FIELD_NAME), projectRoleGV.getString(PROJECT_ROLE_FIELD_DESCRIPTION));
        }
        return role;
    }

    ApplicationUser getUser(String userKey) {
        return ComponentAccessor.getUserManager().getUserByKey(userKey);
    }
}

