/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.AccountNotFoundException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.runtime.CommunicationException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.seraph.auth.AuthenticationContextAwareAuthenticator;
import com.atlassian.seraph.auth.AuthenticationErrorType;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.auth.LoginReason;
import com.atlassian.seraph.elevatedsecurity.ElevatedSecurityGuard;
import com.atlassian.seraph.util.SecurityUtils;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthenticationContextAwareAuthenticator
public class JiraSeraphAuthenticator
extends DefaultAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(JiraSeraphAuthenticator.class);

    protected Principal getUser(String username) {
        return this.getUserManager().getUserByName(username);
    }

    protected boolean authenticate(Principal user, String password) throws AuthenticatorException {
        try {
            this.crowdServiceAuthenticate(user, password);
            return true;
        }
        catch (AccountNotFoundException e) {
            log.debug("authenticate : '" + user.getName() + "' does not exist and cannot be authenticated.");
            return false;
        }
        catch (FailedAuthenticationException e) {
            log.debug("authentication failed: '" + user.getName(), (Throwable)e);
            return false;
        }
        catch (CommunicationException ex) {
            throw new AuthenticatorException(AuthenticationErrorType.CommunicationError);
        }
        catch (OperationFailedException ex) {
            log.error("Error occurred while trying to authenticate user '" + user.getName() + "'.", (Throwable)ex);
            throw new AuthenticatorException(AuthenticationErrorType.UnknownError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crowdServiceAuthenticate(Principal user, String password) throws FailedAuthenticationException {
        Thread currentThread = Thread.currentThread();
        ClassLoader origCCL = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.getCrowdService().authenticate(user.getName(), password);
        }
        finally {
            currentThread.setContextClassLoader(origCCL);
        }
    }

    protected Principal refreshPrincipalObtainedFromSession(HttpServletRequest httpServletRequest, Principal principal) {
        Principal freshPrincipal = principal;
        if (principal != null && principal.getName() != null) {
            freshPrincipal = principal instanceof ApplicationUser ? this.getUserManager().getUserByKey(((ApplicationUser)principal).getKey()) : this.getUser(principal.getName());
            this.putPrincipalInSessionContext(httpServletRequest, freshPrincipal);
        }
        return freshPrincipal;
    }

    protected Principal getUserFromBasicAuthentication(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String METHOD = "getUserFromSession : ";
        boolean dbg = log.isDebugEnabled();
        String header = httpServletRequest.getHeader("Authorization");
        LoginReason reason = LoginReason.OK;
        if (SecurityUtils.isBasicAuthorizationHeader((String)header)) {
            if (dbg) {
                log.debug("getUserFromSession : Looking in Basic Auth headers");
            }
            SecurityUtils.UserPassCredentials creds = SecurityUtils.decodeBasicAuthorizationCredentials((String)header);
            ElevatedSecurityGuard securityGuard = this.getElevatedSecurityGuard();
            if (!securityGuard.performElevatedSecurityCheck(httpServletRequest, creds.getUsername())) {
                if (dbg) {
                    log.debug("getUserFromSession : '" + creds.getUsername() + "' failed elevated security check");
                }
                reason = LoginReason.AUTHENTICATION_DENIED.stampRequestResponse(httpServletRequest, httpServletResponse);
                securityGuard.onFailedLoginAttempt(httpServletRequest, creds.getUsername());
            } else {
                if (dbg) {
                    log.debug("getUserFromSession : '" + creds.getUsername() + "' does not require elevated security check.  Attempting authentication...");
                }
                try {
                    boolean loggedin = this.login(httpServletRequest, httpServletResponse, creds.getUsername(), creds.getPassword(), false);
                    if (loggedin) {
                        reason = LoginReason.OK.stampRequestResponse(httpServletRequest, httpServletResponse);
                        securityGuard.onSuccessfulLoginAttempt(httpServletRequest, creds.getUsername());
                        if (dbg) {
                            log.debug("getUserFromSession : Authenticated '" + creds.getUsername() + "' via Basic Auth");
                        }
                        return this.getUser(creds.getUsername());
                    }
                    reason = LoginReason.AUTHENTICATED_FAILED.stampRequestResponse(httpServletRequest, httpServletResponse);
                    securityGuard.onFailedLoginAttempt(httpServletRequest, creds.getUsername());
                }
                catch (AuthenticatorException e) {
                    log.warn("getUserFromSession : Exception trying to login '" + creds.getUsername() + "' via Basic Auth:" + (Object)((Object)e), (Throwable)e);
                }
            }
            try {
                httpServletResponse.sendError(401, "Basic Authentication Failure - Reason : " + reason.toString());
            }
            catch (IOException e) {
                log.warn("getUserFromSession : Exception trying to send Basic Auth failed error: " + e, (Throwable)e);
            }
            return null;
        }
        try {
            httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"protected-area\"");
            httpServletResponse.sendError(401);
        }
        catch (IOException e) {
            log.warn("getUserFromSession : Exception trying to send Basic Auth failed error: " + e, (Throwable)e);
        }
        return null;
    }

    private CrowdService getCrowdService() {
        return (CrowdService)ComponentAccessor.getComponent(CrowdService.class);
    }

    private UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }
}

