/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme;

import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.workflow.WorkflowSchemeManager;

public class DefaultSchemeManagerFactory
implements SchemeManagerFactory {
    private NotificationSchemeManager notificationSchemeManager;
    private PermissionSchemeManager permissionSchemeManager;
    private WorkflowSchemeManager workflowSchemeManager;
    private IssueSecuritySchemeManager issueSecuritySchemeManager;

    public DefaultSchemeManagerFactory(NotificationSchemeManager notificationSchemeManager, PermissionSchemeManager permissionSchemeManager, WorkflowSchemeManager workflowSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager) {
        this.notificationSchemeManager = notificationSchemeManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
    }

    @Override
    public SchemeManager getSchemeManager(String managerType) {
        if ("NotificationScheme".equals(managerType)) {
            return this.notificationSchemeManager;
        }
        if ("PermissionScheme".equals(managerType)) {
            return this.permissionSchemeManager;
        }
        if ("WorkflowScheme".equals(managerType)) {
            return this.workflowSchemeManager;
        }
        if ("IssueSecurityScheme".equals(managerType)) {
            return this.issueSecuritySchemeManager;
        }
        throw new IllegalArgumentException("This factory can not create a scheme manager for the type: " + managerType);
    }
}

