/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.scheduler.JiraCaesiumSchedulerService;
import com.atlassian.jira.scheduler.OfBizRunDetailsDao;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.quartz1.Quartz1SchedulerService;
import com.atlassian.scheduler.quartz1.spi.Quartz1SchedulerConfiguration;
import com.atlassian.tenancy.api.TenantAccessor;
import org.apache.log4j.Logger;

public class JiraQuartz1SchedulerService
extends Quartz1SchedulerService {
    private static final Logger log = Logger.getLogger(JiraQuartz1SchedulerService.class);
    private final RunDetailsDao runDetailsDao;

    public JiraQuartz1SchedulerService(RunDetailsDao runDetailsDao, Quartz1SchedulerConfiguration config) throws SchedulerServiceException {
        super(runDetailsDao, config, (TenantAccessor)new JiraCaesiumSchedulerService.FakeTenantAccessor());
        this.runDetailsDao = runDetailsDao;
    }

    protected void startImpl() throws SchedulerServiceException {
        boolean ok = false;
        try {
            this.startRunDetailsDao();
            super.startImpl();
            ok = true;
        }
        finally {
            if (!ok) {
                this.stopRunDetailsDao();
            }
        }
    }

    protected void standbyImpl() throws SchedulerServiceException {
        super.standbyImpl();
        this.stopRunDetailsDao();
    }

    protected void shutdownImpl() {
        super.shutdownImpl();
        this.stopRunDetailsDao();
    }

    public void preJob() {
        JiraThreadLocalUtils.preCall();
    }

    public void postJob() {
        JiraThreadLocalUtils.postCall(log, null);
    }

    private void startRunDetailsDao() {
        if (this.runDetailsDao instanceof OfBizRunDetailsDao) {
            ((OfBizRunDetailsDao)this.runDetailsDao).start();
        }
    }

    private void stopRunDetailsDao() {
        if (this.runDetailsDao instanceof OfBizRunDetailsDao) {
            ((OfBizRunDetailsDao)this.runDetailsDao).stop();
        }
    }
}

