/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webpanel.notification;

import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public final class UserLimitExceededContextProvider
implements ContextProvider {
    private final ApplicationRoleManager applicationRoleManager;
    private final BaseUrl baseUrl;

    public UserLimitExceededContextProvider(ApplicationRoleManager applicationRoleManager, BaseUrl baseUrl) {
        this.baseUrl = baseUrl;
        this.applicationRoleManager = (ApplicationRoleManager)Assertions.notNull((String)"applicationRoleManager", (Object)applicationRoleManager);
    }

    public void init(Map<String, String> map) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        if (!this.applicationRoleManager.isAnyRoleLimitExceeded()) {
            throw new IllegalStateException("Application roles are not exceeded  - user limit exceeded context provider should not be called");
        }
        boolean moreThanOne = !this.applicationRoleManager.rolesEnabled() || this.moreThanOneRoleExceeded();
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder().put((Object)"moreThanOne", (Object)moreThanOne).put((Object)"baseUrl", (Object)this.baseUrl.getBaseUrl());
        if (!moreThanOne) {
            contextBuilder.put((Object)"roleName", (Object)this.affectedRoleName().get());
        }
        return contextBuilder.build();
    }

    private boolean moreThanOneRoleExceeded() {
        return this.applicationRoleManager.getRoles().stream().filter(r -> this.applicationRoleManager.isRoleLimitExceeded(r.getKey())).count() > 1L;
    }

    private Optional<String> affectedRoleName() {
        return this.applicationRoleManager.getRoles().stream().filter(r -> this.applicationRoleManager.isRoleLimitExceeded(r.getKey())).findFirst().map(ApplicationRole::getName);
    }
}

