/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyService;
import com.atlassian.jira.bc.issue.properties.IssuePropertyService;
import com.atlassian.jira.bc.issuetype.property.IssueTypePropertyService;
import com.atlassian.jira.bc.project.property.ProjectPropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeWithID;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Map;

@PublicApi
public class EntityPropertyEqualToCondition
extends AbstractWebCondition {
    private final Map<String, Function2<String, String, PropertyCondition>> conditionFactories = ImmutableMap.of((Object)"project", (propertyKey, value) -> new ProjectPropertyCondition(projectPropertyService, (String)propertyKey, (String)value), (Object)"issue", (propertyKey, value) -> new IssuePropertyCondition(issuePropertyService, (String)propertyKey, (String)value), (Object)"comment", (propertyKey, value) -> new CommentPropertyCondition(commentPropertyService, (String)propertyKey, (String)value), (Object)"issuetype", (propertyKey, value) -> new IssueTypePropertyCondition(issueTypePropertyService, (String)propertyKey, (String)value));
    private PropertyCondition condition;

    public EntityPropertyEqualToCondition(CommentPropertyService commentPropertyService, IssuePropertyService issuePropertyService, IssueTypePropertyService issueTypePropertyService, ProjectPropertyService projectPropertyService) {
    }

    public void init(Map<String, String> params) throws PluginParseException {
        super.init(params);
        String entity = this.getNonNullValueFromParameter(params, "entity");
        String propertyKey = this.getNonNullValueFromParameter(params, "propertyKey");
        String expectedValue = this.getNonNullValueFromParameter(params, "value");
        if (!this.conditionFactories.containsKey(entity)) {
            throw new PluginParseException("Invalid entity parameter. Possible values are [" + this.conditionFactories.keySet() + "].");
        }
        this.condition = (PropertyCondition)this.conditionFactories.get(entity).apply((Object)propertyKey, (Object)expectedValue);
    }

    private String getNonNullValueFromParameter(Map<String, String> params, String parameter) {
        String value = params.get(parameter);
        if (value == null) {
            throw new PluginParseException(String.format("No '%s' parameter specified for condition: %s", parameter, ((Object)((Object)this)).getClass().getName()));
        }
        return value;
    }

    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        return this.condition.shouldDisplay(user, jiraHelper);
    }

    private static class IssueTypePropertyCondition
    extends PropertyCondition {
        private IssueTypePropertyCondition(IssueTypePropertyService issueTypePropertyService, String propertyKey, String value) {
            super((EntityPropertyService)issueTypePropertyService, propertyKey, value);
        }

        @Override
        Option<Long> getEntityId(Map<String, Object> context) {
            Issue issue = (Issue)context.get("issue");
            return Option.option((Object)issue).map((Function)new Function<Issue, Long>(){

                public Long apply(Issue issue) {
                    return IssueTypeWithID.fromIssueType((IssueType)issue.getIssueTypeObject()).getId();
                }
            });
        }
    }

    private static class CommentPropertyCondition
    extends PropertyCondition {
        private CommentPropertyCondition(CommentPropertyService commentPropertyService, String propertyKey, String value) {
            super((EntityPropertyService)commentPropertyService, propertyKey, value);
        }

        @Override
        Option<Long> getEntityId(Map<String, Object> context) {
            Comment comment = (Comment)context.get("comment");
            return Option.option((Object)comment).map((Function)new Function<Comment, Long>(){

                public Long apply(Comment comment) {
                    return comment.getId();
                }
            });
        }
    }

    private static class IssuePropertyCondition
    extends PropertyCondition {
        private IssuePropertyCondition(IssuePropertyService issuePropertyService, String propertyKey, String value) {
            super((EntityPropertyService)issuePropertyService, propertyKey, value);
        }

        @Override
        Option<Long> getEntityId(Map<String, Object> context) {
            Issue issue = (Issue)context.get("issue");
            return Option.option((Object)issue).map((Function)new Function<Issue, Long>(){

                public Long apply(Issue issue) {
                    return issue.getId();
                }
            });
        }
    }

    private static class ProjectPropertyCondition
    extends PropertyCondition {
        private ProjectPropertyCondition(ProjectPropertyService projectPropertyService, String propertyKey, String value) {
            super((EntityPropertyService)projectPropertyService, propertyKey, value);
        }

        @Override
        Option<Long> getEntityId(Map<String, Object> context) {
            Project project = (Project)context.get("project");
            return Option.option((Object)project).map((Function)new Function<Project, Long>(){

                public Long apply(Project project) {
                    return project.getId();
                }
            });
        }
    }

    private static abstract class PropertyCondition {
        private final String propertyKey;
        private final String value;
        private final EntityPropertyService service;
        private final JsonParser jsonParser = new JsonParser();

        protected PropertyCondition(EntityPropertyService service, String propertyKey, String value) {
            this.service = service;
            this.propertyKey = propertyKey;
            this.value = value;
        }

        public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
            Option<Long> entityId = this.getEntityId(jiraHelper.getContextParams());
            if (entityId.isEmpty()) {
                return false;
            }
            EntityPropertyService.PropertyResult propertyResult = this.service.getProperty(user, (Long)entityId.get(), this.propertyKey);
            if (!propertyResult.isValid()) {
                return false;
            }
            Option entityProperty = propertyResult.getEntityProperty();
            return (Boolean)entityProperty.fold(Suppliers.alwaysFalse(), (Function)new Function<EntityProperty, Boolean>(){

                public Boolean apply(EntityProperty entityProperty) {
                    JsonElement jsonElement = jsonParser.parse(entityProperty.getValue());
                    return jsonElement.isJsonPrimitive() && jsonElement.getAsString().equals(value);
                }
            });
        }

        abstract Option<Long> getEntityId(Map<String, Object> var1);
    }
}

