/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.userformat.configuration;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.userformat.configuration.UserFormatTypeConfiguration;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;

@EventComponent
public class PropertySetBackedUserFormatTypeConfiguration
implements UserFormatTypeConfiguration {
    private final CachedReference<PropertySet> mappingPSRef;

    public PropertySetBackedUserFormatTypeConfiguration(JiraPropertySetFactory jiraPropertySetFactory, CacheManager cacheManager) {
        this.mappingPSRef = cacheManager.getCachedReference(this.getClass(), "mappingPSRef", (Supplier)new UserFormatMappingSupplier(jiraPropertySetFactory));
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.mappingPSRef.reset();
    }

    @Override
    public void setUserFormatKeyForType(String userFormatType, String moduleKey) {
        ((PropertySet)this.mappingPSRef.get()).setString(userFormatType, moduleKey);
        this.mappingPSRef.reset();
    }

    @Override
    public String getUserFormatKeyForType(String userFormatType) {
        return ((PropertySet)this.mappingPSRef.get()).getString(userFormatType);
    }

    @Override
    public boolean containsType(String userFormatType) {
        return ((PropertySet)this.mappingPSRef.get()).getString(userFormatType) != null;
    }

    @Override
    public void remove(String userFormatType) {
        ((PropertySet)this.mappingPSRef.get()).remove(userFormatType);
        this.mappingPSRef.reset();
    }

    Collection<String> getConfiguredTypes() {
        return ((PropertySet)this.mappingPSRef.get()).getKeys();
    }

    static class UserFormatMappingSupplier
    implements Supplier<PropertySet> {
        static final String USER_FORMAT_CONFIGURATION_PROPERTY_SET_KEY = "user.format.mapping";
        private final JiraPropertySetFactory jiraPropertySetFactory;

        public UserFormatMappingSupplier(JiraPropertySetFactory jiraPropertySetFactory) {
            this.jiraPropertySetFactory = jiraPropertySetFactory;
        }

        public PropertySet get() {
            return this.jiraPropertySetFactory.buildCachingDefaultPropertySet(USER_FORMAT_CONFIGURATION_PROPERTY_SET_KEY, true);
        }
    }
}

