/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.annotations.Internal;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import org.apache.commons.beanutils.PropertyUtils;

@Internal
public class JiraCacheResetter {
    private final Delegate delegate = new Delegate();

    public JiraCacheResetter(EventPublisher eventPublisher) {
        eventPublisher.register((Object)this.delegate);
    }

    public static class Delegate {
        private volatile boolean jiraIsShuttingDown = false;

        @EventListener
        public void onPluginDisabled(PluginDisabledEvent pluginDisabledEvent) {
            this.resetCaches();
        }

        @EventListener
        public void onPluginEnabled(PluginEnabledEvent pluginEnabledEvent) {
            this.resetCaches();
        }

        @EventListener
        public void onPluginModuleDisabled(PluginModuleDisabledEvent pluginModuleDisabledEvent) {
            this.resetCaches();
        }

        @EventListener
        public void onPluginModuleEnabled(PluginModuleEnabledEvent pluginModuleEnabledEvent) {
            this.resetCaches();
        }

        @EventListener
        public void onJiraShuttingDown(ComponentManagerShutdownEvent shutdownEvent) {
            this.jiraIsShuttingDown = true;
        }

        private void resetCaches() {
            PortletConfigurationStore store;
            FieldScreenManager screenManager;
            FieldManager fieldManager;
            if (this.jiraIsShuttingDown) {
                return;
            }
            CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
            if (customFieldManager != null) {
                customFieldManager.refresh();
            }
            if ((fieldManager = ComponentAccessor.getFieldManager()) != null) {
                fieldManager.refresh();
            }
            if ((screenManager = ComponentAccessor.getFieldScreenManager()) != null) {
                screenManager.refresh();
            }
            if ((store = (PortletConfigurationStore)ComponentAccessor.getComponent(PortletConfigurationStore.class)) instanceof FlushablePortletConfigurationStore) {
                ((FlushablePortletConfigurationStore)store).flush();
            }
            PropertyUtils.clearDescriptors();
        }
    }
}

