/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.mail.MailServiceQueueItemBuilder;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.velocity.exception.VelocityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MentionMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = LoggerFactory.getLogger(MentionMailQueueItem.class);
    private final ApplicationUser from;
    private final NotificationRecipient recipient;
    private final RendererManager rendererManager;
    private final Map<String, Object> context;
    private final MailQueue mailQueue;
    private final IssueRenderContext issueRenderContext;
    private final String subjectTemplatePath = "templates/email/subject/issuementioned.vm";

    public MentionMailQueueItem(ApplicationUser from, NotificationRecipient recipient, Map<String, Object> context, IssueRenderContext issueRenderContext, RendererManager rendererManager, MailQueue mailQueue) {
        this.from = from;
        this.recipient = recipient;
        this.rendererManager = rendererManager;
        this.context = context;
        this.mailQueue = mailQueue;
        this.issueRenderContext = issueRenderContext;
    }

    public String getSubject() {
        I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        HashMap contextParams = Maps.newHashMap(this.context);
        contextParams.put("i18n", i18n);
        try {
            return this.renderEmailSubject(contextParams);
        }
        catch (VelocityException e) {
            log.error("Could not determine e-mail subject", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void send() throws MailException {
        String format = this.recipient.getFormat();
        String bodyTemplatePath = "templates/email/" + format + "/issuementioned.vm";
        String comment = (String)this.context.get("comment");
        String content = this.rendererManager.getRenderedContent("atlassian-wiki-renderer", comment, this.issueRenderContext);
        this.context.put("htmlComment", content);
        MailQueueItem item = new MailServiceQueueItemBuilder(this.from, this.recipient, "templates/email/subject/issuementioned.vm", bodyTemplatePath, this.context).buildQueueItemUsingProjectEmailAsReplyTo();
        this.mailQueue.addItem(item);
    }

    private String renderEmailSubject(Map<String, Object> contextParams) {
        return this.getTemplatingEngine().render(TemplateSources.file((String)"templates/email/subject/issuementioned.vm")).applying(contextParams).asPlainText();
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }

    @VisibleForTesting
    protected MailQueue getMailQueue() {
        return this.mailQueue;
    }
}

