/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.core.util.Clock;
import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.license.DefaultLicenseDetails;
import com.atlassian.jira.license.DefaultLicenseStatusMessage;
import com.atlassian.jira.license.JiraProductLicense;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.jira.web.util.OutlookDate;
import java.util.Date;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SubscriptionLicenseDetails
extends DefaultLicenseDetails {
    static final long WARNING_PERIOD_IN_MSEC = 3628800000L;
    private static final long HOUR_RESOLUTION = 2L;

    public SubscriptionLicenseDetails(@Nonnull JiraProductLicense license, @Nonnull String licenseString, @Nonnull ApplicationProperties applicationProperties, @Nonnull ExternalLinkUtil externalLinkUtil, @Nonnull BuildUtilsInfo buildUtilsInfo, @Nonnull I18nHelper.BeanFactory i18nFactory, @Nonnull DateTimeFormatter dateTimeFormatter, @Nonnull Clock clock) throws IllegalArgumentException {
        super(license, licenseString, applicationProperties, externalLinkUtil, buildUtilsInfo, i18nFactory, dateTimeFormatter, clock);
        if (license.getExpiryDate() == null) {
            throw new IllegalArgumentException("Subscription licenses must have a finite expiry date; given license is unlimited");
        }
    }

    @Override
    public boolean isExpired() {
        return this.getLicenseExpiry().getTime() < this.getCurrentTime();
    }

    @Override
    public boolean isLicenseAlmostExpired() {
        return this.getLicenseExpiry().getTime() > this.getCurrentTime() - 3628800000L;
    }

    @Override
    @Nonnull
    Date getLicenseExpiry() {
        return this.getJiraLicense().getExpiryDate();
    }

    @Override
    public LicenseDetails.LicenseStatusMessage getLicenseStatusMessage(@Nonnull I18nHelper i18n, UserManager ignored) {
        Date expiryDate = this.getJiraLicense().getExpiryDate();
        String expiry = this.getDateTimeFormatter().withLocale(i18n.getLocale()).withStyle(DateTimeStyle.COMPLETE).format(expiryDate);
        if (this.isExpired()) {
            return DefaultLicenseStatusMessage.builder().add("admin.license.support.and.updates", i18n.getText("admin.license.nbol.updates.only", expiry)).add("admin.license.renewal.target", this.renewalMessage(i18n)).add("admin.license.status", i18n.getText("admin.enterprise.license.has.expired", expiry)).add("admin.license.renewal", this.renewalMessage(i18n)).build();
        }
        if (this.isLicenseAlmostExpired()) {
            return DefaultLicenseStatusMessage.builder().add("admin.license.status", i18n.getText("admin.enterprise.license.has.almost.expired", expiry)).add("admin.license.renewal", this.renewalMessage(i18n)).build();
        }
        return DefaultLicenseStatusMessage.builder().add("admin.license.status", i18n.getText("admin.enterprise.license.status", expiry)).build();
    }

    @Override
    public String getLicenseExpiryStatusMessage(@Nonnull I18nHelper i18n, @Nullable OutlookDate date) {
        if (this.isExpired()) {
            return "(" + i18n.getText("admin.enterprise.license.expired") + ")";
        }
        String timeUntilExpiry = DateUtils.dateDifference((long)System.currentTimeMillis(), (long)this.getJiraLicense().getExpiryDate().getTime(), (long)2L, (ResourceBundle)i18n.getDefaultResourceBundle());
        return i18n.getText("admin.enterprise.license.expiresin", timeUntilExpiry);
    }

    @Override
    public LicenseDetails.LicenseStatusMessage getMaintenanceMessage(@Nonnull I18nHelper i18n, String applicationName) {
        return DefaultLicenseStatusMessage.builder().build();
    }

    private String renewalMessage(@Nonnull I18nHelper i18n) {
        ExternalLinkUtil linkUtil = this.getExternalLinkUtil();
        String myAtlassianUrl = linkUtil.getProperty("external.link.jira.license.renew");
        String myAtlassianHref = String.format("<a href=\"%s\">", myAtlassianUrl);
        String salesEmail = linkUtil.getProperty("external.link.atlassian.sales.mail.to");
        String salesHrefOpen = String.format("<a href=\"mailto:%s\">", salesEmail);
        String hrefClose = "</a>";
        return i18n.getText("admin.enterprise.license.renewal", myAtlassianHref, hrefClose, salesHrefOpen, hrefClose);
    }
}

