/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.jira.license.LicenseDetails;
import com.google.common.collect.ImmutableList;
import java.util.List;

public interface LicenseCheck {
    public static final Result PASS = new Result((List<LicenseDetails>)ImmutableList.of(), "");
    public static final Result FAIL = new Failure((List<LicenseDetails>)ImmutableList.of(), "");
    public static final Result FAIL_NO_LICENSES = new Failure((List<LicenseDetails>)ImmutableList.of(), "No licenses present");

    public Result evaluate();

    public static class Failure
    extends Result {
        public Failure(List<LicenseDetails> failedLicenses, String reason) {
            super(failedLicenses, reason);
        }

        @Override
        public boolean isPass() {
            return false;
        }
    }

    public static class Result {
        private final List<LicenseDetails> failedLicenses;
        private final String reason;

        public Result(List<LicenseDetails> failedLicenses, String reason) {
            this.failedLicenses = failedLicenses;
            this.reason = reason;
        }

        public List<LicenseDetails> getFailedLicenses() {
            return this.failedLicenses;
        }

        public String getFailureMessage() {
            return this.reason;
        }

        public boolean isPass() {
            return this.failedLicenses.isEmpty();
        }
    }
}

