/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.ClauseTooComplexSearchException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.util.LuceneQueryModifier;
import com.atlassian.jira.jql.query.ContextAwareQueryVisitor;
import com.atlassian.jira.jql.query.LuceneQueryBuilder;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryVisitor;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.Clause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

@InjectableComponent
public class DefaultLuceneQueryBuilder
implements LuceneQueryBuilder {
    private final QueryVisitor queryVisitor;
    private final LuceneQueryModifier luceneQueryModifier;

    public DefaultLuceneQueryBuilder(QueryVisitor queryVisitor, LuceneQueryModifier luceneQueryModifier) {
        this.queryVisitor = queryVisitor;
        this.luceneQueryModifier = luceneQueryModifier;
    }

    @Override
    public Query createLuceneQuery(QueryCreationContext queryCreationContext, Clause clause) throws SearchException {
        Query luceneQuery;
        try {
            luceneQuery = this.queryVisitor.createQuery(clause, queryCreationContext);
        }
        catch (ContextAwareQueryVisitor.JqlTooComplex jqlTooComplex) {
            throw new ClauseTooComplexSearchException(jqlTooComplex.getClause());
        }
        try {
            return this.luceneQueryModifier.getModifiedQuery(luceneQuery);
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            throw new ClauseTooComplexSearchException(clause);
        }
    }
}

