/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.clause;

import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.ChangedClauseImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.MultiClause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.clause.WasClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DeMorgansVisitor
implements ClauseVisitor<Clause> {
    private int notCount = 0;

    public Clause visit(NotClause notClause) {
        ++this.notCount;
        Clause logicalClause = (Clause)notClause.getSubClause().accept((ClauseVisitor)this);
        --this.notCount;
        return logicalClause;
    }

    public Clause visit(AndClause andClause) {
        List<Clause> nodes = this.visitChildren((MultiClause)andClause);
        if (this.isNegating()) {
            return new OrClause(nodes);
        }
        return new AndClause(nodes);
    }

    public Clause visit(OrClause orClause) {
        List<Clause> nodes = this.visitChildren((MultiClause)orClause);
        if (this.isNegating()) {
            return new AndClause(nodes);
        }
        return new OrClause(nodes);
    }

    public Clause visit(TerminalClause terminalClause) {
        if (this.isNegating()) {
            Operator notOperator = DeMorgansVisitor.getNotOperator(terminalClause.getOperator());
            if (notOperator != null) {
                return new TerminalClauseImpl(terminalClause.getName(), notOperator, terminalClause.getOperand(), terminalClause.getProperty());
            }
            return new NotClause((Clause)terminalClause);
        }
        return terminalClause;
    }

    public Clause visit(WasClause clause) {
        if (this.isNegating()) {
            return new WasClauseImpl(clause.getName(), DeMorgansVisitor.getNotOperator(clause.getOperator()), clause.getOperand(), clause.getPredicate());
        }
        return clause;
    }

    public Clause visit(ChangedClause clause) {
        if (this.isNegating()) {
            return new ChangedClauseImpl(clause.getField(), DeMorgansVisitor.getNotOperator(clause.getOperator()), clause.getPredicate());
        }
        return clause;
    }

    private boolean isNegating() {
        return this.notCount % 2 == 1;
    }

    private List<Clause> visitChildren(MultiClause multiClause) {
        ArrayList<Clause> nodes = new ArrayList<Clause>(multiClause.getClauses().size());
        for (Clause logicalClause : multiClause.getClauses()) {
            nodes.add((Clause)logicalClause.accept((ClauseVisitor)this));
        }
        return nodes;
    }

    private static Operator getNotOperator(Operator operator) {
        switch (operator) {
            case IS: {
                return Operator.IS_NOT;
            }
            case IS_NOT: {
                return Operator.IS;
            }
            case IN: {
                return Operator.NOT_IN;
            }
            case NOT_IN: {
                return Operator.IN;
            }
            case LIKE: {
                return Operator.NOT_LIKE;
            }
            case NOT_LIKE: {
                return Operator.LIKE;
            }
            case EQUALS: {
                return Operator.NOT_EQUALS;
            }
            case NOT_EQUALS: {
                return Operator.EQUALS;
            }
            case GREATER_THAN: {
                return Operator.LESS_THAN_EQUALS;
            }
            case GREATER_THAN_EQUALS: {
                return Operator.LESS_THAN;
            }
            case LESS_THAN: {
                return Operator.GREATER_THAN_EQUALS;
            }
            case LESS_THAN_EQUALS: {
                return Operator.GREATER_THAN;
            }
            case WAS: {
                return Operator.WAS_NOT;
            }
            case WAS_NOT: {
                return Operator.WAS;
            }
            case CHANGED: {
                return Operator.NOT_CHANGED;
            }
            case NOT_CHANGED: {
                return Operator.CHANGED;
            }
        }
        return null;
    }

    @InjectableComponent
    public static class DeMorgansVisitorFactory {
        public DeMorgansVisitor createDeMorgansVisitor() {
            return new DeMorgansVisitor();
        }
    }
}

