/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.PropertiesUtil;
import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.index.AccumulatingResultBuilder;
import com.atlassian.jira.index.DefaultIndex;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.Index;
import com.atlassian.jira.index.IndexingStrategy;
import com.atlassian.jira.index.MultiThreadedIndexingConfiguration;
import com.atlassian.jira.index.MultiThreadedIndexingStrategy;
import com.atlassian.jira.index.Operations;
import com.atlassian.jira.index.RelatedEntityDocumentFactory;
import com.atlassian.jira.index.SimpleIndexingStrategy;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryGroup;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.index.ChangeHistoryDocumentFactory;
import com.atlassian.jira.issue.index.CommentDocumentFactory;
import com.atlassian.jira.issue.index.IndexDirectoryFactory;
import com.atlassian.jira.issue.index.IndexingMode;
import com.atlassian.jira.issue.index.IssueDocumentFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.LuceneIssueIndexProvider;
import com.atlassian.jira.issue.index.WorklogDocumentFactory;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;

public class DefaultIssueIndexer
implements IssueIndexer {
    private final CommentRetriever commentRetriever;
    private final ChangeHistoryRetriever changeHistoryRetriever;
    private final WorklogRetriever worklogRetriever;
    private final MultiThreadedIndexingConfiguration multiThreadedIndexingConfiguration;
    private final LuceneIssueIndexProvider lifecycle;
    private final IssueDocumentFactory issueDocumentFactory;
    private final CommentDocumentFactory commentDocumentFactory;
    private final ChangeHistoryDocumentFactory changeHistoryDocumentFactory;
    private final WorklogDocumentFactory worklogDocumentFactory;
    private final IndexingStrategy simpleIndexingStrategy = new SimpleIndexingStrategy();
    private final DocumentCreationStrategy documentCreationStrategy = new DefaultDocumentCreationStrategy();

    public DefaultIssueIndexer(@Nonnull IndexDirectoryFactory indexDirectoryFactory, @Nonnull CommentRetriever commentRetriever, @Nonnull ChangeHistoryRetriever changeHistoryRetriever, @Nonnull WorklogRetriever worklogRetriever, @Nonnull ApplicationProperties applicationProperties, @Nonnull IssueDocumentFactory issueDocumentFactory, @Nonnull CommentDocumentFactory commentDocumentFactory, @Nonnull ChangeHistoryDocumentFactory changeHistoryDocumentFactory, @Nonnull WorklogDocumentFactory worklogDocumentFactory) {
        this.lifecycle = new LuceneIssueIndexProvider(indexDirectoryFactory);
        this.commentRetriever = (CommentRetriever)Assertions.notNull((String)"commentRetriever", (Object)commentRetriever);
        this.changeHistoryRetriever = (ChangeHistoryRetriever)Assertions.notNull((String)"changeHistoryReriever", (Object)changeHistoryRetriever);
        this.worklogRetriever = (WorklogRetriever)Assertions.notNull((String)"worklogRetriever", (Object)worklogRetriever);
        this.issueDocumentFactory = (IssueDocumentFactory)Assertions.notNull((String)"issueDocumentFactory", (Object)issueDocumentFactory);
        this.commentDocumentFactory = (CommentDocumentFactory)Assertions.notNull((String)"commentDocumentFactory", (Object)commentDocumentFactory);
        this.changeHistoryDocumentFactory = (ChangeHistoryDocumentFactory)Assertions.notNull((String)"changeHistoryDocumentFactory", (Object)changeHistoryDocumentFactory);
        this.worklogDocumentFactory = (WorklogDocumentFactory)Assertions.notNull((String)"worklogDocumentFactory", (Object)worklogDocumentFactory);
        this.multiThreadedIndexingConfiguration = new PropertiesAdapter(applicationProperties);
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result deindexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context) {
        return DefaultIssueIndexer.perform(issues, this.simpleIndexingStrategy, context, new IndexOperation(){

            @Override
            public Index.Result perform(Issue issue, Context.Task task) {
                try {
                    Term issueTerm = DefaultIssueIndexer.this.issueDocumentFactory.getIdentifyingTerm(issue);
                    Index.Operation delete = Operations.newDelete(issueTerm, Index.UpdateMode.INTERACTIVE);
                    Index.Operation onCompletion = Operations.newCompletionDelegate(delete, new TaskCompleter(task));
                    AccumulatingResultBuilder results = new AccumulatingResultBuilder();
                    results.add("Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(onCompletion));
                    results.add("Comment For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(delete));
                    results.add("Change History For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(delete));
                    results.add("Worklog For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getWorklogIndex().perform(delete));
                    return results.toResult();
                }
                catch (Exception ex) {
                    return new DefaultIndex.Failure(ex);
                }
            }
        });
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result indexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context) {
        return this.indexIssues(issues, context, IssueIndexingParams.INDEX_ALL);
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result indexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        return DefaultIssueIndexer.perform(issues, this.simpleIndexingStrategy, context, new IndexIssuesOperation(Index.UpdateMode.INTERACTIVE, issueIndexingParams));
    }

    @Override
    @GuardedBy(value="external index write lock")
    public Index.Result indexIssuesBatchMode(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context) {
        return this.indexIssuesBatchMode(issues, context, IssueIndexingParams.INDEX_ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="external index write lock")
    public Index.Result indexIssuesBatchMode(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, @Nonnull IssueIndexingParams issueIndexingParams) {
        try {
            this.lifecycle.close();
            this.lifecycle.setMode(IndexingMode.DIRECT);
            Index.Result result = DefaultIssueIndexer.perform(issues, (IndexingStrategy)new MultiThreadedIndexingStrategy(this.simpleIndexingStrategy, this.multiThreadedIndexingConfiguration, "IssueIndexer"), context, new IndexIssuesOperation(Index.UpdateMode.BATCH, issueIndexingParams));
            return result;
        }
        finally {
            this.lifecycle.close();
            this.lifecycle.setMode(IndexingMode.QUEUED);
        }
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, final IssueIndexingParams issueIndexingParams, final boolean conditionalUpdate) {
        return DefaultIssueIndexer.perform(issues, this.simpleIndexingStrategy, context, new IndexOperation(){

            @Override
            public Index.Result perform(Issue issue, Context.Task task) {
                try {
                    AccumulatingResultBuilder results = new AccumulatingResultBuilder();
                    Index.UpdateMode mode = Index.UpdateMode.INTERACTIVE;
                    Documents documents = DefaultIssueIndexer.this.documentCreationStrategy.get(issue, issueIndexingParams);
                    Term issueTerm = documents.getIdentifyingTerm();
                    Index.Operation update = conditionalUpdate ? Operations.newConditionalUpdate(issueTerm, documents.getIssue(), mode, "updated") : Operations.newUpdate(issueTerm, documents.getIssue(), mode);
                    Index.Operation onCompletion = Operations.newCompletionDelegate(update, new TaskCompleter(task));
                    if (issueIndexingParams.isIndexIssues()) {
                        results.add("Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(onCompletion));
                    }
                    if (issueIndexingParams.isIndexComments()) {
                        results.add("Comment For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(Operations.newUpdate(issueTerm, documents.getComments(), mode)));
                    }
                    if (issueIndexingParams.isIndexChangeHistory()) {
                        results.add("Change History For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(Operations.newUpdate(issueTerm, documents.getChanges(), mode)));
                    }
                    if (issueIndexingParams.isIndexWorklogs()) {
                        results.add("Worklog For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getWorklogIndex().perform(Operations.newUpdate(issueTerm, documents.getWorklogs(), mode)));
                    }
                    DefaultIssueIndexer.this.flushCustomFieldValueCache();
                    return results.toResult();
                }
                catch (Exception ex) {
                    return new DefaultIndex.Failure(ex);
                }
            }
        });
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexIssues(@Nonnull EnclosedIterable<Issue> issues, @Nonnull Context context, boolean reIndexComments, boolean reIndexChangeHistory, boolean conditionalUpdate) {
        IssueIndexingParams issueIndexingParams = IssueIndexingParams.builder().setComments(reIndexComments).setChangeHistory(reIndexChangeHistory).build();
        return this.reindexIssues(issues, context, issueIndexingParams, conditionalUpdate);
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexComments(@Nonnull Collection<Comment> comments, @Nonnull Context context) {
        return DefaultIssueIndexer.perform(comments, this.simpleIndexingStrategy, context, new RelatedEntityOperation<Comment>(this.commentDocumentFactory, IndexDirectoryFactory.Name.COMMENT));
    }

    @Override
    @GuardedBy(value="external index read lock")
    public Index.Result reindexWorklogs(@Nonnull Collection<Worklog> worklogs, @Nonnull Context context) {
        return DefaultIssueIndexer.perform(worklogs, this.simpleIndexingStrategy, context, new RelatedEntityOperation<Worklog>(this.worklogDocumentFactory, IndexDirectoryFactory.Name.WORKLOG));
    }

    @Override
    public void deleteIndexes() {
        for (Index.Manager manager : this.lifecycle) {
            manager.deleteIndexDirectory();
        }
    }

    @Override
    public void deleteIndexes(IssueIndexingParams issueIndexingParams) {
        Set<IndexDirectoryFactory.Name> indexes = this.transformIndexingParamsToIndexesEnumSet(issueIndexingParams);
        for (IndexDirectoryFactory.Name indexName : indexes) {
            this.lifecycle.get(indexName).deleteIndexDirectory();
        }
    }

    @Override
    public IndexSearcher openEntitySearcher(IndexDirectoryFactory.Name index) {
        return this.lifecycle.get(index).openSearcher();
    }

    @Override
    public Index.Result optimize() {
        AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
        for (Index.Manager manager : this.lifecycle) {
            builder.add(manager.getIndex().perform(Operations.newOptimize()));
        }
        return builder.toResult();
    }

    @Override
    public void shutdown() {
        this.lifecycle.close();
    }

    @Override
    public List<String> getIndexPaths() {
        return this.lifecycle.getIndexPaths();
    }

    @Override
    public String getIndexRootPath() {
        return this.lifecycle.getIndexRootPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Index.Result perform(EnclosedIterable<Issue> issues, final IndexingStrategy strategy, final Context context, final IndexOperation operation) {
        try {
            Assertions.notNull((String)"issues", issues);
            final AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
            issues.foreach((Consumer)new Consumer<Issue>(){

                public void consume(final @Nonnull Issue issue) {
                    final Context.Task task = context.start((Object)issue);
                    Index.Result result = (Index.Result)strategy.get(new Supplier<Index.Result>(){

                        public Index.Result get() {
                            return operation.perform(issue, task);
                        }
                    });
                    builder.add("Issue", issue.getId(), result);
                }
            });
            Index.Result result = builder.toResult();
            return result;
        }
        finally {
            strategy.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends WithId> Index.Result perform(Iterable<T> entities, IndexingStrategy strategy, Context context, final EntityOperation<T> operation) {
        try {
            Assertions.notNull((String)"entities", entities);
            AccumulatingResultBuilder builder = new AccumulatingResultBuilder();
            for (final WithId entity : entities) {
                final Context.Task task = context.start((Object)entity);
                Index.Result result = (Index.Result)strategy.get(new Supplier<Index.Result>(){

                    public Index.Result get() {
                        return operation.perform(entity, task);
                    }
                });
                builder.add("Entity", entity.getId(), result);
            }
            Index.Result result = builder.toResult();
            return result;
        }
        finally {
            strategy.close();
        }
    }

    private void flushCustomFieldValueCache() {
        Map customFieldValueCache = (Map)JiraAuthenticationContextImpl.getRequestCache().get("jira.customfield.values.cache");
        if (customFieldValueCache != null) {
            customFieldValueCache.clear();
        }
    }

    private Set<IndexDirectoryFactory.Name> transformIndexingParamsToIndexesEnumSet(IssueIndexingParams issueIndexingParams) {
        EnumSet<IndexDirectoryFactory.Name> indexes = EnumSet.noneOf(IndexDirectoryFactory.Name.class);
        if (issueIndexingParams.isIndexIssues()) {
            indexes.add(IndexDirectoryFactory.Name.ISSUE);
        }
        if (issueIndexingParams.isIndexComments()) {
            indexes.add(IndexDirectoryFactory.Name.COMMENT);
        }
        if (issueIndexingParams.isIndexChangeHistory()) {
            indexes.add(IndexDirectoryFactory.Name.CHANGE_HISTORY);
        }
        if (issueIndexingParams.isIndexWorklogs()) {
            indexes.add(IndexDirectoryFactory.Name.WORKLOG);
        }
        return indexes;
    }

    static class PropertiesAdapter
    implements MultiThreadedIndexingConfiguration {
        private final ApplicationProperties applicationProperties;

        PropertiesAdapter(ApplicationProperties applicationProperties) {
            this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        }

        @Override
        public int minimumBatchSize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.minbatchsize", (int)50);
        }

        @Override
        public int maximumQueueSize() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.maxqueuesize", (int)1000);
        }

        @Override
        public int noOfThreads() {
            return PropertiesUtil.getIntProperty((ApplicationProperties)this.applicationProperties, (String)"jira.index.issue.threads", (int)20);
        }
    }

    class DefaultDocumentCreationStrategy
    implements DocumentCreationStrategy {
        DefaultDocumentCreationStrategy() {
        }

        @Override
        public Documents get(Issue issue, IssueIndexingParams issueIndexingParams) {
            DocumentBuilder commentDocumentBuilder = this.getDocumentBuilder(DefaultIssueIndexer.this.commentRetriever, DefaultIssueIndexer.this.commentDocumentFactory);
            DocumentBuilder changeHistoryDocumentBuilder = this.getDocumentBuilder(DefaultIssueIndexer.this.changeHistoryRetriever, DefaultIssueIndexer.this.changeHistoryDocumentFactory);
            DocumentBuilder worklogDocumentBuilder = this.getDocumentBuilder(DefaultIssueIndexer.this.worklogRetriever, DefaultIssueIndexer.this.worklogDocumentFactory);
            List<Option<Document>> comments = issueIndexingParams.isIndexComments() ? (Collection)commentDocumentBuilder.apply(issue) : Collections.emptyList();
            List<Option<Document>> changes = issueIndexingParams.isIndexChangeHistory() ? (Collection)changeHistoryDocumentBuilder.apply(issue) : Collections.emptyList();
            List<Option<Document>> worklogs = issueIndexingParams.isIndexWorklogs() ? (Collection)worklogDocumentBuilder.apply(issue) : Collections.emptyList();
            Option issues = (Option)DefaultIssueIndexer.this.issueDocumentFactory.apply(issue);
            return new Documents(issue, (Option<Document>)issues, comments, changes, worklogs);
        }

        private <T> DocumentBuilder getDocumentBuilder(final EntityRetriever<T> retriever, final EntityDocumentFactory<T> documentFactory) {
            return new DocumentBuilder(){

                public Collection<Option<Document>> apply(@Nullable Issue issue) {
                    return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((Iterable)retriever.apply(issue)), (Function)documentFactory));
                }
            };
        }
    }

    static interface DocumentBuilder
    extends Function<Issue, Collection<Option<Document>>> {
    }

    private static class LuceneDocumentsBuilder
    implements Effect<Document> {
        private final ImmutableList.Builder<Document> builder = ImmutableList.builder();

        private LuceneDocumentsBuilder() {
        }

        public static List<Document> foreach(Collection<Option<Document>> documents) {
            LuceneDocumentsBuilder luceneDocumentsBuilder = new LuceneDocumentsBuilder();
            for (Option<Document> document : documents) {
                document.foreach((Effect)luceneDocumentsBuilder);
            }
            return luceneDocumentsBuilder.builder.build();
        }

        public void apply(Document luceneDocument) {
            this.builder.add((Object)luceneDocument);
        }
    }

    class Documents {
        private final Document issueDocument;
        private final List<Document> comments;
        private final List<Document> changes;
        private final List<Document> worklogs;
        private final Term term;

        Documents(Issue issue, Option<Document> issueDocument, Collection<Option<Document>> comments, Collection<Option<Document>> changes, Collection<Option<Document>> worklogs) {
            Preconditions.checkArgument((boolean)issueDocument.isDefined(), (Object)"Issue document bust be defined");
            this.issueDocument = (Document)issueDocument.get();
            this.comments = LuceneDocumentsBuilder.foreach(comments);
            this.changes = LuceneDocumentsBuilder.foreach(changes);
            this.worklogs = LuceneDocumentsBuilder.foreach(worklogs);
            this.term = DefaultIssueIndexer.this.issueDocumentFactory.getIdentifyingTerm(issue);
        }

        Document getIssue() {
            return this.issueDocument;
        }

        List<Document> getComments() {
            return this.comments;
        }

        List<Document> getWorklogs() {
            return this.worklogs;
        }

        List<Document> getChanges() {
            return this.changes;
        }

        Term getIdentifyingTerm() {
            return this.term;
        }
    }

    static interface DocumentCreationStrategy {
        public Documents get(Issue var1, IssueIndexingParams var2);
    }

    private static class TaskCompleter
    implements Runnable {
        private final Context.Task task;

        public TaskCompleter(Context.Task task) {
            this.task = task;
        }

        @Override
        public void run() {
            this.task.complete();
        }
    }

    private class RelatedEntityOperation<T>
    implements EntityOperation<T> {
        private final RelatedEntityDocumentFactory<T> factory;
        private final IndexDirectoryFactory.Name index;

        RelatedEntityOperation(RelatedEntityDocumentFactory<T> factory, IndexDirectoryFactory.Name index) {
            this.factory = factory;
            this.index = index;
        }

        @Override
        public Index.Result perform(T entity, Context.Task task) {
            try {
                Index.UpdateMode mode = Index.UpdateMode.INTERACTIVE;
                Option document = (Option)this.factory.apply(entity);
                Term identifyingTerm = this.factory.getIdentifyingTerm(entity);
                if (document.isEmpty()) {
                    return new DefaultIndex.Failure(new RuntimeException("Entity undefined"));
                }
                return DefaultIssueIndexer.this.lifecycle.getIndex(this.index).perform(Operations.newUpdate(identifyingTerm, (Document)document.get(), mode));
            }
            catch (Exception ex) {
                return new DefaultIndex.Failure(ex);
            }
        }
    }

    private static interface EntityOperation<T> {
        public Index.Result perform(T var1, Context.Task var2);
    }

    private static interface IndexOperation
    extends EntityOperation<Issue> {
    }

    private class IndexIssuesOperation
    implements IndexOperation {
        final Index.UpdateMode mode;
        final IssueIndexingParams issueIndexingParams;

        IndexIssuesOperation(Index.UpdateMode mode, IssueIndexingParams issueIndexingParams) {
            this.mode = mode;
            this.issueIndexingParams = issueIndexingParams;
        }

        @Override
        public Index.Result perform(Issue issue, Context.Task task) {
            try {
                Documents documents = DefaultIssueIndexer.this.documentCreationStrategy.get(issue, this.issueIndexingParams);
                Index.Operation issueCreate = Operations.newCreate(documents.getIssue(), this.mode);
                Index.Operation onCompletion = Operations.newCompletionDelegate(issueCreate, new TaskCompleter(task));
                AccumulatingResultBuilder results = new AccumulatingResultBuilder();
                results.add("Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getIssueIndex().perform(onCompletion));
                if (!documents.getComments().isEmpty()) {
                    Index.Operation commentsCreate = Operations.newCreate(documents.getComments(), this.mode);
                    results.add("Comment For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getCommentIndex().perform(commentsCreate));
                }
                if (!documents.getChanges().isEmpty()) {
                    Index.Operation changeHistoryCreate = Operations.newCreate(documents.getChanges(), this.mode);
                    results.add("Change History For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getChangeHistoryIndex().perform(changeHistoryCreate));
                }
                if (!documents.getWorklogs().isEmpty()) {
                    Index.Operation worklogsCreate = Operations.newCreate(documents.getWorklogs(), this.mode);
                    results.add("Worklog For Issue", issue.getId(), DefaultIssueIndexer.this.lifecycle.getWorklogIndex().perform(worklogsCreate));
                }
                DefaultIssueIndexer.this.flushCustomFieldValueCache();
                return results.toResult();
            }
            catch (Exception ex) {
                return new DefaultIndex.Failure(ex);
            }
        }
    }

    public static interface WorklogRetriever
    extends EntityRetriever<Worklog> {
    }

    public static interface ChangeHistoryRetriever
    extends EntityRetriever<ChangeHistoryGroup> {
    }

    public static interface CommentRetriever
    extends EntityRetriever<Comment> {
    }

    public static interface EntityRetriever<T>
    extends Function<Issue, List<T>> {
    }
}

