/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntityImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;

public class DefaultFieldScreenFactory
implements FieldScreenFactory {
    private final ConstantsManager constantsManager;
    private final FieldScreenManager fieldScreenManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;

    public DefaultFieldScreenFactory(ConstantsManager constantsManager, FieldScreenManager fieldScreenManager, FieldScreenSchemeManager fieldScreenSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager) {
        this.constantsManager = constantsManager;
        this.fieldScreenManager = fieldScreenManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
    }

    public FieldScreen createScreen() {
        return new FieldScreenImpl(this.fieldScreenManager);
    }

    public FieldScreenScheme createFieldScreenScheme() {
        return new FieldScreenSchemeImpl(this.fieldScreenSchemeManager);
    }

    public FieldScreenSchemeItem createFieldScreenSchemeItem() {
        return new FieldScreenSchemeItemImpl(this.fieldScreenSchemeManager, this.fieldScreenManager);
    }

    public IssueTypeScreenScheme createIssueTypeScreenScheme() {
        return new IssueTypeScreenSchemeImpl(this.issueTypeScreenSchemeManager);
    }

    public IssueTypeScreenSchemeEntity createIssueTypeScreenSchemeEntity() {
        return new IssueTypeScreenSchemeEntityImpl(this.issueTypeScreenSchemeManager, this.fieldScreenSchemeManager, this.constantsManager);
    }
}

