/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ChangeHistoryBatch {
    private static final Logger log = LoggerFactory.getLogger(ChangeHistoryBatch.class);
    private static final int MAX_ELEMS_IN_CLAUSE = 750;
    @Nonnull
    private final OfBizDelegator ofBizDelegator;
    @Nonnull
    private final IssueManager issueManager;
    @Nonnull
    private final UserManager userManager;
    @Nonnull
    private ImmutableMap<Long, Issue> issues;
    @Nonnull
    private final ImmutableList<ChangeHistory> changeHistories;
    @Nullable
    private ImmutableMap<ChangeHistory, List<GenericValue>> batchChangeItems;

    static ChangeHistoryBatch createBatchForIssue(@Nonnull Iterable<Issue> issues, OfBizDelegator ofBizDelegator, IssueManager issueManager, UserManager userManager) {
        return new ChangeHistoryBatch(issues, ofBizDelegator, issueManager, userManager);
    }

    private ChangeHistoryBatch(@Nonnull Iterable<Issue> issues, @Nonnull OfBizDelegator ofBizDelegator, @Nonnull IssueManager issueManager, @Nonnull UserManager userManager) throws NullPointerException {
        this.issues = ImmutableMap.copyOf((Map)Maps.uniqueIndex(issues, (Function)new GetIssueIdFn()));
        this.issueManager = (IssueManager)Assertions.notNull((String)"issueManager", (Object)issueManager);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.ofBizDelegator = (OfBizDelegator)Assertions.notNull((String)"ofBizDelegator", (Object)ofBizDelegator);
        this.changeHistories = this.fetchAllChangeGroups();
    }

    List<ChangeHistory> asList() {
        return Lists.newArrayList(this.changeHistories);
    }

    private ImmutableList<ChangeHistory> fetchAllChangeGroups() {
        if (this.issues.isEmpty()) {
            return ImmutableList.of();
        }
        log.debug("About to fetch change groups for issues: {}", (Object)this.issues.keySet());
        try (OfBizListIterator changeGroups = this.ofBizDelegator.findListIteratorByCondition("ChangeGroup", (EntityCondition)new EntityExpr("issue", EntityOperator.IN, (Object)this.issues.keySet()), null, null, (List)ImmutableList.of((Object)"created ASC", (Object)"id ASC"), null);){
            log.debug("Fetched {} change groups");
            ImmutableList<ChangeHistory> immutableList = this.wrapChangeHistories((Iterable<GenericValue>)changeGroups);
            return immutableList;
        }
    }

    private ImmutableMap<ChangeHistory, List<GenericValue>> fetchAllChangeItems() {
        if (this.changeHistories.isEmpty()) {
            return ImmutableMap.of();
        }
        HashMap changeHistoriesById = Maps.newHashMapWithExpectedSize((int)this.changeHistories.size());
        for (ChangeHistory changeHistory : this.changeHistories) {
            changeHistoriesById.put(changeHistory.getId(), changeHistory);
        }
        ArrayListMultimap changeItemsByChangeGroup = ArrayListMultimap.create();
        List allChangeHistoryIds = Ordering.natural().sortedCopy(changeHistoriesById.keySet());
        int size = allChangeHistoryIds.size();
        for (int subListStart = 0; subListStart < size; subListStart += 750) {
            int subListEnd = subListStart + Math.min(750, size - subListStart);
            List batchOfChangeHistoryIds = allChangeHistoryIds.subList(subListStart, subListEnd);
            log.debug("About to fetch change items for a batch of {} change groups", (Object)batchOfChangeHistoryIds.size());
            List changeItems = this.ofBizDelegator.findByAnd("ChangeItem", (List)ImmutableList.of((Object)new EntityExpr("group", EntityOperator.IN, batchOfChangeHistoryIds)));
            if (changeItems == null) {
                changeItems = Collections.emptyList();
            }
            log.debug("Fetched {} change items", (Object)changeItems.size());
            for (GenericValue changeItem : changeItems) {
                Long parentId = changeItem.getLong("group");
                ChangeHistory parent = (ChangeHistory)changeHistoriesById.get(parentId);
                if (parent != null) {
                    changeItemsByChangeGroup.put((Object)parent, (Object)changeItem);
                    continue;
                }
                log.error("Change item {} is not a child of change groups: {}", (Object)parentId, batchOfChangeHistoryIds);
            }
        }
        return ChangeHistoryBatch.makeImmutable(changeItemsByChangeGroup);
    }

    private ImmutableList<ChangeHistory> wrapChangeHistories(Iterable<GenericValue> changeHistories) {
        if (changeHistories == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(changeHistories, (Function)new Function<GenericValue, ChangeHistory>(){

            public ChangeHistory apply(@Nullable GenericValue changeHistory) {
                return changeHistory != null ? new ChangeHistoryWithLazyLoadedChangeItems(changeHistory) : null;
            }
        }));
    }

    private static <T, U> ImmutableMap<T, List<U>> makeImmutable(Multimap<? extends T, ? extends U> multimap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            builder.put(entry.getKey(), (Object)Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
        }
        return builder.build();
    }

    private class ChangeHistoryWithLazyLoadedChangeItems
    extends ChangeHistory {
        public ChangeHistoryWithLazyLoadedChangeItems(GenericValue changeHistoryGV) {
            super(changeHistoryGV, ChangeHistoryBatch.this.issueManager, ChangeHistoryBatch.this.userManager);
        }

        public Issue getIssue() {
            return (Issue)ChangeHistoryBatch.this.issues.get((Object)this.getIssueId());
        }

        public List<GenericValue> getChangeItems() {
            List<GenericValue> result;
            if (ChangeHistoryBatch.this.batchChangeItems == null) {
                ChangeHistoryBatch.this.batchChangeItems = ChangeHistoryBatch.this.fetchAllChangeItems();
            }
            if ((result = (List<GenericValue>)ChangeHistoryBatch.this.batchChangeItems.get((Object)this)) == null) {
                result = Collections.emptyList();
            }
            return result;
        }
    }

    private static class GetIssueIdFn
    implements Function<Issue, Long> {
        private GetIssueIdFn() {
        }

        public Long apply(Issue issue) {
            return issue.getId();
        }
    }
}

