/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Suppliers;
import com.atlassian.fugue.Unit;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.AttachmentKey;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.FileBasedAttachmentStore;
import com.atlassian.jira.issue.attachment.FileSystemAttachmentStore;
import com.atlassian.jira.issue.attachment.StoreAttachmentBean;
import com.atlassian.jira.issue.attachment.StoreAttachmentResult;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.io.File;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BackwardCompatibleStoreAdapter
implements StreamAttachmentStore,
FileBasedAttachmentStore {
    private final StreamAttachmentStore streamAttachmentStore;
    private final Option<FileSystemAttachmentStore> fileSystemAttachmentStore;

    public BackwardCompatibleStoreAdapter(StreamAttachmentStore streamAttachmentStore, Option<FileSystemAttachmentStore> fileSystemAttachmentStore) {
        this.streamAttachmentStore = streamAttachmentStore;
        this.fileSystemAttachmentStore = fileSystemAttachmentStore;
    }

    public File getAttachmentFile(final AttachmentKey attachmentKey) throws DataAccessException {
        return this.delegateToFileStoreOrThrowException(new Function<FileBasedAttachmentStore, File>(){

            public File apply(FileBasedAttachmentStore fileBasedAttachmentStore) {
                return fileBasedAttachmentStore.getAttachmentFile(attachmentKey);
            }
        });
    }

    public File getAttachmentFile(final AttachmentStore.AttachmentAdapter attachment, final File attachmentDir) {
        return this.delegateToFileStoreOrThrowException(new Function<FileBasedAttachmentStore, File>(){

            public File apply(FileBasedAttachmentStore fileBasedAttachmentStore) {
                return fileBasedAttachmentStore.getAttachmentFile(attachment, attachmentDir);
            }
        });
    }

    private File delegateToFileStoreOrThrowException(Function<FileBasedAttachmentStore, File> delegateToFileStore) {
        return (File)this.fileSystemAttachmentStore.fold((Supplier)new Supplier<File>(){

            public File get() {
                throw new UnsupportedOperationException("Direct operations on file system are not supported.");
            }
        }, delegateToFileStore);
    }

    public Promise<Unit> deleteAttachmentContainerForIssue(final @Nonnull Issue issue) {
        return (Promise)this.fileSystemAttachmentStore.fold(Suppliers.ofInstance((Object)Promises.promise((Object)Unit.VALUE)), (Function)new Function<FileBasedAttachmentStore, Promise<Unit>>(){

            public Promise<Unit> apply(FileBasedAttachmentStore fileBasedAttachmentStore) {
                return fileBasedAttachmentStore.deleteAttachmentContainerForIssue(issue);
            }
        });
    }

    public Promise<StoreAttachmentResult> putAttachment(StoreAttachmentBean storeAttachmentBean) {
        return this.streamAttachmentStore.putAttachment(storeAttachmentBean);
    }

    public <A> Promise<A> getAttachment(AttachmentKey attachmentKey, com.atlassian.util.concurrent.Function<InputStream, A> inputStreamProcessor) {
        return this.streamAttachmentStore.getAttachment(attachmentKey, inputStreamProcessor);
    }

    public <A> Promise<A> getAttachmentData(AttachmentKey attachmentKey, com.atlassian.util.concurrent.Function<AttachmentGetData, A> attachmentGetDataProcessor) {
        return this.streamAttachmentStore.getAttachmentData(attachmentKey, attachmentGetDataProcessor);
    }

    public Promise<Unit> moveAttachment(AttachmentKey oldAttachmentKey, AttachmentKey newAttachmentKey) {
        return this.streamAttachmentStore.moveAttachment(oldAttachmentKey, newAttachmentKey);
    }

    public Promise<Unit> copyAttachment(AttachmentKey sourceAttachmentKey, AttachmentKey newAttachmentKey) {
        return this.streamAttachmentStore.copyAttachment(sourceAttachmentKey, newAttachmentKey);
    }

    public Promise<Unit> deleteAttachment(AttachmentKey attachmentKey) {
        return this.streamAttachmentStore.deleteAttachment(attachmentKey);
    }

    public Promise<TemporaryAttachmentId> putTemporaryAttachment(InputStream inputStream, long size) {
        return this.streamAttachmentStore.putTemporaryAttachment(inputStream, size);
    }

    public Promise<Unit> moveTemporaryToAttachment(TemporaryAttachmentId temporaryAttachmentId, AttachmentKey destinationKey) {
        return this.streamAttachmentStore.moveTemporaryToAttachment(temporaryAttachmentId, destinationKey);
    }

    public Promise<Unit> deleteTemporaryAttachment(TemporaryAttachmentId temporaryAttachmentId) {
        return this.streamAttachmentStore.deleteTemporaryAttachment(temporaryAttachmentId);
    }

    public Promise<Boolean> exists(AttachmentKey attachmentKey) {
        return this.streamAttachmentStore.exists(attachmentKey);
    }

    @Nonnull
    public Option<ErrorCollection> errors() {
        return this.streamAttachmentStore.errors();
    }

    public boolean hasFileSystemAvailable() {
        return this.fileSystemAttachmentStore.isDefined();
    }

    @VisibleForTesting
    StreamAttachmentStore getStreamAttachmentStore() {
        return this.streamAttachmentStore;
    }
}

