/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.BulkAttachmentOperations;
import com.atlassian.jira.ofbiz.DatabaseIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.EnclosedIterable;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.GenericValue;

public final class DefaultBulkAttachmentOperations
implements BulkAttachmentOperations {
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;
    private Resolver<GenericValue, Attachment> attachmentResolver = new Resolver<GenericValue, Attachment>(){

        public Attachment get(GenericValue attachmentGV) {
            return new Attachment(DefaultBulkAttachmentOperations.this.issueManager, attachmentGV, OFBizPropertyUtils.getPropertySet(attachmentGV));
        }
    };

    public DefaultBulkAttachmentOperations(IssueManager issueManager, OfBizDelegator ofBizDelegator) {
        this.issueManager = issueManager;
        this.ofBizDelegator = ofBizDelegator;
    }

    public EnclosedIterable<Attachment> getAttachmentOfIssue(@Nonnull Issue issue) {
        return CollectionEnclosedIterable.from((Collection)issue.getAttachments());
    }

    public EnclosedIterable<Attachment> getAllAttachments() {
        long size = this.ofBizDelegator.getCount("FileAttachment");
        return new DatabaseIterable<Attachment>((int)size, this.attachmentResolver){

            @Override
            protected OfBizListIterator createListIterator() {
                return DefaultBulkAttachmentOperations.this.ofBizDelegator.findListIteratorByCondition("FileAttachment", null, null, null, null, EntityFindOptions.findOptions().forwardOnly().readOnly());
            }
        };
    }
}

