/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.ofbiz.AbstractOfBizValueWrapper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericValue;

public class IssueConstantImpl
extends AbstractOfBizValueWrapper
implements IssueConstant {
    private final TranslationManager translationManager;
    private final JiraAuthenticationContext authenticationContext;
    private final BaseUrl locator;
    private final LazyReference<PropertySet> propertySetRef = new LazyReference<PropertySet>(){

        protected PropertySet create() throws Exception {
            return OFBizPropertyUtils.getCachingPropertySet(IssueConstantImpl.this.genericValue.getEntityName(), new Long(IssueConstantImpl.this.genericValue.getString("id")));
        }
    };
    @ClusterSafe
    private final Map<String, String> nameTranslations = new MapMaker().concurrencyLevel(1).makeComputingMap((Function)new IssueConstantTranslationFunction(true));
    @ClusterSafe
    private final Map<String, String> descriptionTranslations = new MapMaker().concurrencyLevel(1).makeComputingMap((Function)new IssueConstantTranslationFunction(false));
    @ClusterSafe
    private final ResettableLazyReference<Long> sequence = new ResettableLazyReference<Long>(){

        protected Long create() throws Exception {
            return IssueConstantImpl.this.genericValue.getLong("sequence");
        }
    };

    public IssueConstantImpl(GenericValue genericValue, TranslationManager translationManager, JiraAuthenticationContext authenticationContext, BaseUrl locator) {
        super(genericValue);
        this.translationManager = translationManager;
        this.authenticationContext = authenticationContext;
        this.locator = locator;
    }

    public String getId() {
        return this.genericValue.getString("id");
    }

    public String getName() {
        return this.genericValue.getString("name");
    }

    public void setName(String name) {
        this.genericValue.setString("name", name);
    }

    public String getDescription() {
        return this.genericValue.getString("description");
    }

    public void setDescription(String description) {
        this.genericValue.setString("description", description);
    }

    public Long getSequence() {
        return (Long)this.sequence.get();
    }

    public void setSequence(Long seq) {
        this.genericValue.set("sequence", (Object)seq);
        this.sequence.reset();
    }

    public String getCompleteIconUrl() {
        String iconUrl = StringUtils.stripToNull((String)this.getIconUrl());
        if (iconUrl == null) {
            return null;
        }
        if (iconUrl.startsWith("http://") || iconUrl.startsWith("https://")) {
            return iconUrl;
        }
        return this.locator.getBaseUrl() + iconUrl;
    }

    public String getIconUrl() {
        return this.genericValue.getString("iconurl");
    }

    public String getIconUrlHtml() {
        return StringEscapeUtils.escapeHtml((String)this.getIconUrl());
    }

    public void setIconUrl(String iconURL) {
        this.genericValue.setString("iconurl", iconURL);
    }

    public String getNameTranslation() {
        return this.nameTranslations.get(this.authenticationContext.getLocale().toString());
    }

    public String getDescTranslation() {
        return this.descriptionTranslations.get(this.authenticationContext.getLocale().toString());
    }

    public String getNameTranslation(String locale) {
        return this.nameTranslations.get(locale);
    }

    public String getDescTranslation(String locale) {
        return this.descriptionTranslations.get(locale);
    }

    public String getNameTranslation(I18nHelper i18n) {
        return this.translationManager.getIssueConstantTranslation((IssueConstant)this, true, i18n.getLocale().toString(), i18n);
    }

    public String getDescTranslation(I18nHelper i18n) {
        return this.translationManager.getIssueConstantTranslation((IssueConstant)this, false, i18n.getLocale().toString(), i18n);
    }

    public void setTranslation(String translatedName, String translatedDesc, String issueConstantPrefix, Locale locale) {
        this.translationManager.setIssueConstantTranslation((IssueConstant)this, issueConstantPrefix, locale, translatedName, translatedDesc);
        this.nameTranslations.remove(locale.toString());
        this.descriptionTranslations.remove(locale.toString());
    }

    public void deleteTranslation(String issueConstantPrefix, Locale locale) {
        this.translationManager.deleteIssueConstantTranslation((IssueConstant)this, issueConstantPrefix, locale);
        this.nameTranslations.remove(locale.toString());
        this.descriptionTranslations.remove(locale.toString());
    }

    public int compareTo(Object o) {
        return this.genericValue.compareTo((GenericEntity)((IssueConstantImpl)((Object)o)).getGenericValue());
    }

    public PropertySet getPropertySet() {
        return (PropertySet)this.propertySetRef.get();
    }

    private class IssueConstantTranslationFunction
    implements Function<String, String> {
        private final boolean isName;

        private IssueConstantTranslationFunction(boolean isName) {
            this.isName = isName;
        }

        public String apply(String key) {
            String translation = null;
            Locale locale = LocaleParser.parseLocale((String)key);
            if (locale != null) {
                translation = IssueConstantImpl.this.translationManager.getIssueConstantTranslation((IssueConstant)IssueConstantImpl.this, this.isName, locale);
            }
            return translation == null ? "" : translation;
        }
    }
}

