/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.fugue.Option;
import com.atlassian.jira.issue.attachment.StreamAttachmentStore;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentsMonitorLocator;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.issue.DefaultTemporaryWebAttachmentsMonitor;
import com.atlassian.jira.web.action.issue.TemporaryWebAttachmentsMonitor;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DefaultTemporaryWebAttachmentsMonitorLocator
implements TemporaryWebAttachmentsMonitorLocator {
    private final StreamAttachmentStore attachmentStore;

    public DefaultTemporaryWebAttachmentsMonitorLocator(StreamAttachmentStore attachmentStore) {
        this.attachmentStore = attachmentStore;
    }

    private Option<TemporaryWebAttachmentsMonitor> getMonitorFromSession(Option<HttpSession> session) {
        return session.flatMap((Function)new Function<HttpSession, Option<TemporaryWebAttachmentsMonitor>>(){

            public Option<TemporaryWebAttachmentsMonitor> apply(HttpSession session) {
                return Option.option((Object)((TemporaryWebAttachmentsMonitor)session.getAttribute("jira.issue.temp.web_attachments")));
            }
        });
    }

    private TemporaryWebAttachmentsMonitor createNewMonitor(HttpSession session) {
        DefaultTemporaryWebAttachmentsMonitor monitor = new DefaultTemporaryWebAttachmentsMonitor(this.attachmentStore);
        session.setAttribute("jira.issue.temp.web_attachments", (Object)monitor);
        return monitor;
    }

    private Option<HttpSession> getCurrentSession() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        return request == null ? Option.none() : Option.some((Object)request.getSession());
    }

    @Override
    public Option<TemporaryWebAttachmentsMonitor> get() {
        Option<HttpSession> currentSession = this.getCurrentSession();
        return this.getMonitorFromSession(currentSession);
    }

    @Override
    public TemporaryWebAttachmentsMonitor getOrCreate() {
        Option<HttpSession> sessionOption = this.getCurrentSession();
        final HttpSession session = (HttpSession)sessionOption.getOrThrow((Supplier)new Supplier<IllegalStateException>(){

            public IllegalStateException get() {
                throw new IllegalStateException("Session doesn't exists, this method cannot work outside HTTP session!");
            }
        });
        return (TemporaryWebAttachmentsMonitor)this.getMonitorFromSession(sessionOption).getOrElse((Supplier)new Supplier<TemporaryWebAttachmentsMonitor>(){

            public TemporaryWebAttachmentsMonitor get() {
                return DefaultTemporaryWebAttachmentsMonitorLocator.this.createNewMonitor(session);
            }
        });
    }
}

