/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalChangeItem;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.ChangeItemParser;
import com.atlassian.jira.util.dbc.Null;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ChangeItemParserImpl
implements ChangeItemParser {
    private static final String ID = "id";
    private static final String GROUP = "group";
    private static final String FIELD_TYPE = "fieldtype";
    private static final String FIELD = "field";
    private static final String OLD_VALUE = "oldvalue";
    private static final String OLD_STRING = "oldstring";
    private static final String NEW_VALUE = "newvalue";
    private static final String NEW_STRING = "newstring";

    @Override
    public ExternalChangeItem parse(Map attributes) throws ParseException {
        Null.not("attributes", attributes);
        String id = (String)attributes.get(ID);
        String changeGroupId = (String)attributes.get(GROUP);
        String fieldType = (String)attributes.get(FIELD_TYPE);
        String field = (String)attributes.get(FIELD);
        String oldvalue = (String)attributes.get(OLD_VALUE);
        String oldstring = (String)attributes.get(OLD_STRING);
        String newvalue = (String)attributes.get(NEW_VALUE);
        String newstring = (String)attributes.get(NEW_STRING);
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("A change item must have an id specified.");
        }
        if (StringUtils.isEmpty((String)changeGroupId)) {
            throw new ParseException("Change item '" + id + "' is missing the change group id.");
        }
        if (StringUtils.isEmpty((String)field)) {
            throw new ParseException("Change item '" + id + "' is missing the 'field' attribute.");
        }
        return new ExternalChangeItem(id, changeGroupId, fieldType, field, oldvalue, oldstring, newvalue, newstring);
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalChangeItem changeItem) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ID, changeItem.getId());
        attributes.put(GROUP, changeItem.getChangeGroupId());
        attributes.put(FIELD_TYPE, changeItem.getFieldType());
        attributes.put(FIELD, changeItem.getField());
        attributes.put(OLD_VALUE, changeItem.getOldValue());
        attributes.put(OLD_STRING, changeItem.getOldString());
        attributes.put(NEW_VALUE, changeItem.getNewValue());
        attributes.put(NEW_STRING, changeItem.getNewString());
        return new EntityRepresentationImpl("ChangeItem", attributes);
    }
}

