/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.search;

import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.event.issue.property.IssuePropertyDeletedEvent;
import com.atlassian.jira.event.issue.property.IssuePropertySetEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class IssuePropertyEventListener {
    private static final Logger log = LoggerFactory.getLogger(IssuePropertyEventListener.class);
    private final IssueManager issueManager;
    private final IssueIndexManager issueIndexManager;

    public IssuePropertyEventListener(IssueManager issueManager, IssueIndexManager issueIndexManager) {
        this.issueManager = issueManager;
        this.issueIndexManager = issueIndexManager;
    }

    @EventListener
    public void onIssuePropertySet(IssuePropertySetEvent issuePropertySetEvent) {
        this.reIndex(issuePropertySetEvent.getEntityProperty());
    }

    @EventListener
    public void onIssuePropertyDeleted(IssuePropertyDeletedEvent issuePropertyDeletedEvent) {
        this.reIndex(issuePropertyDeletedEvent.getEntityProperty());
    }

    private void reIndex(EntityProperty entityProperty) {
        this.getIssue(entityProperty).foreach((Effect)new Effect<MutableIssue>(){

            public void apply(MutableIssue issue) {
                try {
                    IssuePropertyEventListener.this.issueIndexManager.reIndex((Issue)issue, IssueIndexingParams.INDEX_ISSUE_ONLY);
                }
                catch (IndexException e) {
                    log.error(String.format("Error during reindex of issue %s", issue.getKey()), (Throwable)e);
                }
            }
        });
    }

    private Option<MutableIssue> getIssue(EntityProperty entityProperty) {
        return Option.option((Object)this.issueManager.getIssueObject(entityProperty.getEntityId()));
    }
}

