/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.issue.IssueEventParamsTransformer;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueEventManager
implements IssueEventManager {
    private final IssueEventParamsTransformer paramsTransformer;
    private final EventPublisher eventPublisher;

    public DefaultIssueEventManager(IssueEventParamsTransformer paramsTransformer, EventPublisher eventPublisher) {
        this.paramsTransformer = paramsTransformer;
        this.eventPublisher = (EventPublisher)Assertions.notNull((Object)eventPublisher);
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, boolean sendMail) {
        this.dispatchEvent(eventTypeId, issue, Collections.emptyMap(), remoteUser, sendMail);
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, Map<String, Object> params, ApplicationUser remoteUser, boolean sendMail) {
        this.publishEvent(new IssueEvent(issue, this.transformParams(params), remoteUser, eventTypeId, sendMail));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, Map<String, Object> params, ApplicationUser remoteUser, boolean sendMail) {
        this.publishAsRedundant(new IssueEvent(issue, this.transformParams(params), remoteUser, eventTypeId, sendMail));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, Map params, ApplicationUser remoteUser) {
        this.publishEvent(new IssueEvent(issue, params, remoteUser, eventTypeId));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(null), eventTypeId));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(null), eventTypeId));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, boolean sendMail) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(null), eventTypeId, sendMail));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, sendMail));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, sendMail));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, GenericValue changelog, boolean sendMail, boolean subtasksUpdated) {
        this.publishEvent(new IssueEvent(issue, remoteUser, null, null, changelog, this.transformParams(null), eventTypeId, sendMail, subtasksUpdated));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, GenericValue changelog, boolean sendMail, boolean subtasksUpdated) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, null, null, changelog, this.transformParams(null), eventTypeId, sendMail, subtasksUpdated));
    }

    public void dispatchEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail, boolean subtasksUpdated) {
        this.publishEvent(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, sendMail, subtasksUpdated));
    }

    public void dispatchRedundantEvent(Long eventTypeId, Issue issue, ApplicationUser remoteUser, Comment comment, Worklog worklog, GenericValue changelog, Map params, boolean sendMail, boolean subtasksUpdated) {
        this.publishAsRedundant(new IssueEvent(issue, remoteUser, comment, worklog, changelog, this.transformParams(params), eventTypeId, sendMail, subtasksUpdated));
    }

    public void dispatchEvent(IssueEventBundle issueEventBundle) {
        for (Object event : issueEventBundle.getEvents()) {
            this.publishEvent(event);
        }
        this.publishEvent(issueEventBundle);
    }

    private Map<String, Object> transformParams(Map<String, Object> params) {
        return this.paramsTransformer.transformParams(params);
    }

    protected void publishEvent(Object event) {
        if (this.areNotificationsEnabled()) {
            this.eventPublisher.publish(event);
        }
    }

    @VisibleForTesting
    boolean areNotificationsEnabled() {
        return ImportUtils.isEnableNotifications();
    }

    @VisibleForTesting
    void publishAsRedundant(@Nonnull IssueEvent issueEvent) {
        issueEvent.makeRedundant();
        this.publishEvent(issueEvent);
    }
}

