/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Node {
    public static Node NOT_CLUSTERED = new Node();
    private final String nodeId;
    private final NodeState state;
    private final Long timestamp;
    private final String ip;
    private final Long cacheListenerPort;

    public Node(String nodeId, NodeState state, Long timestamp, String ip, Long cacheListenerPort) {
        this.nodeId = Assertions.notBlank((String)"nodeId", (String)nodeId);
        this.state = (NodeState)((Object)Assertions.notNull((String)"state", (Object)((Object)state)));
        this.timestamp = timestamp;
        this.ip = ip;
        this.cacheListenerPort = cacheListenerPort;
    }

    public Node(String nodeId, NodeState state) {
        this.nodeId = Assertions.notBlank((String)"nodeId", (String)nodeId);
        this.state = (NodeState)((Object)Assertions.notNull((String)"state", (Object)((Object)state)));
        this.timestamp = null;
        this.ip = null;
        this.cacheListenerPort = null;
    }

    private Node() {
        this.nodeId = null;
        this.state = NodeState.ACTIVE;
        this.timestamp = null;
        this.ip = null;
        this.cacheListenerPort = null;
    }

    @Nonnull
    public NodeState getState() {
        return this.state;
    }

    @Nullable
    public String getNodeId() {
        return this.nodeId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean isClustered() {
        return this.nodeId != null;
    }

    public String getIp() {
        return this.ip;
    }

    public Long getCacheListenerPort() {
        return this.cacheListenerPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equal((Object)this.ip, (Object)node.ip) && Objects.equal((Object)this.cacheListenerPort, (Object)node.cacheListenerPort) && Objects.equal((Object)this.nodeId, (Object)node.nodeId) && Objects.equal((Object)((Object)this.state), (Object)((Object)node.state)) && Objects.equal((Object)this.timestamp, (Object)node.timestamp);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nodeId, this.state, this.timestamp, this.ip, this.cacheListenerPort});
    }

    public static enum NodeState {
        ACTIVE("admin.systeminfo.cluster.node.state.active"),
        PASSIVE("admin.systeminfo.cluster.node.state.passive"),
        ACTIVATING("admin.systeminfo.cluster.node.state.activating"),
        PASSIVATING("admin.systeminfo.cluster.node.state.passivating"),
        OFFLINE("admin.systeminfo.cluster.node.state.offline");

        private final String i18nKey;

        private NodeState(String i18nKey) {
            this.i18nKey = i18nKey;
        }

        public String getI18nKey() {
            return this.i18nKey;
        }
    }
}

