/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user;

import com.atlassian.annotations.Internal;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public class CreateUserApplicationHelper {
    private final ApplicationRoleManager applicationRoleManager;
    private final I18nHelper i18nHelper;
    private final BaseUrl baseUrl;

    public CreateUserApplicationHelper(ApplicationRoleManager applicationRoleManager, I18nHelper i18nHelper, BaseUrl baseUrl) {
        this.applicationRoleManager = applicationRoleManager;
        this.i18nHelper = i18nHelper;
        this.baseUrl = baseUrl;
    }

    public boolean isSingleApplicationInstance() {
        return this.applicationRoleManager.getRoles().size() == 1;
    }

    @Nonnull
    public List<ApplicationSelection> getApplicationsForSelection() {
        return this.getApplicationsForSelection(Collections.emptySet());
    }

    @Nonnull
    public List<ApplicationSelection> getApplicationsForSelection(@Nonnull Set<ApplicationKey> selectedApplicationKeys) {
        Assertions.notNull((String)"selectedApplicationKeys", selectedApplicationKeys);
        if (!this.applicationRoleManager.rolesEnabled()) {
            return ImmutableList.of();
        }
        HashSet applicationSelection = Sets.newHashSet();
        Set roles = this.applicationRoleManager.getRoles();
        Option coreRole = this.applicationRoleManager.getRole(ApplicationKeys.CORE);
        for (ApplicationRole role : roles) {
            String displayName = coreRole.isDefined() && !role.getKey().equals((Object)ApplicationKeys.CORE) ? this.i18nHelper.getText("admin.adduser.application.selection.name.includes.core", role.getName(), ((ApplicationRole)coreRole.get()).getName()) : this.i18nHelper.getText("admin.adduser.application.selection.name.without.core", role.getName());
            Option<String> errorMessage = this.validateRole(role);
            ApplicationKey applicationKey = role.getKey();
            boolean selected = selectedApplicationKeys.contains(applicationKey);
            applicationSelection.add(new ApplicationSelection(applicationKey, displayName, (String)errorMessage.getOrNull(), errorMessage.isEmpty(), selected));
        }
        return Ordering.natural().sortedCopy((Iterable)applicationSelection);
    }

    @Nonnull
    public Collection<String> validateDefaultApplications() {
        return this.validateApplicationKeys(this.applicationRoleManager.getDefaultApplicationKeys());
    }

    @Nonnull
    public Collection<String> validateApplicationKeys(@Nonnull Set<ApplicationKey> applicationKeys) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.applicationRoleManager.rolesEnabled()) {
            return errors;
        }
        Assertions.containsNoNulls((String)"applicationKeys", applicationKeys);
        for (ApplicationKey applicationKey : applicationKeys) {
            Option role = this.applicationRoleManager.getRole(applicationKey);
            if (role.isEmpty()) {
                errors.add(this.i18nHelper.getText("admin.errors.user.add.user.application.not.licensed", applicationKey.value()));
                continue;
            }
            Option<String> message = this.postValidateRole((ApplicationRole)role.get());
            if (!message.isDefined()) continue;
            errors.add((String)message.get());
        }
        return ImmutableList.copyOf(errors);
    }

    @Nonnull
    private Option<String> validateRole(@Nonnull ApplicationRole role) {
        if (role.getDefaultGroups().isEmpty()) {
            return Option.some((Object)this.getApplicationAccessLink("admin.errors.user.add.user.application.no.default.group"));
        }
        if (!this.applicationRoleManager.hasSeatsAvailable(role.getKey(), 1)) {
            return Option.some((Object)this.getApplicationAccessLink("admin.errors.user.add.user.application.license.limit.reached"));
        }
        return Option.none();
    }

    @Nonnull
    private Option<String> postValidateRole(@Nonnull ApplicationRole role) {
        if (role.getDefaultGroups().isEmpty()) {
            return Option.some((Object)this.i18nHelper.getText("admin.errors.user.add.user.application.no.default.group.for.application", role.getName()));
        }
        if (!this.applicationRoleManager.hasSeatsAvailable(role.getKey(), 1)) {
            return Option.some((Object)this.i18nHelper.getText("admin.errors.user.add.user.application.license.limit.reached.for.application", role.getName()));
        }
        return Option.none();
    }

    private String getApplicationAccessLink(String key) {
        String start = String.format("<a href=\"%s\">", this.baseUrl.getBaseUrl() + "/secure/admin/ApplicationAccess.jspa");
        return this.i18nHelper.getText(key, start, "</a>");
    }

    public static final class ApplicationSelection
    implements Comparable<ApplicationSelection> {
        private final ApplicationKey key;
        private final String displayName;
        private final String message;
        private final boolean selectable;
        private final boolean selected;

        ApplicationSelection(@Nonnull ApplicationKey key, @Nonnull String displayName, @Nullable String message, boolean selectable, boolean selected) {
            this.key = key;
            this.displayName = displayName;
            this.message = message;
            this.selectable = selectable;
            this.selected = selected;
        }

        public String getKey() {
            return this.key.value();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSelectable() {
            return this.selectable;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ApplicationSelection)) {
                return false;
            }
            ApplicationSelection that = (ApplicationSelection)o;
            if (this.selectable != that.selectable) {
                return false;
            }
            if (this.selected != that.selected) {
                return false;
            }
            if (!this.displayName.equals(that.displayName)) {
                return false;
            }
            if (!this.key.equals((Object)that.key)) {
                return false;
            }
            return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.displayName.hashCode();
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            result = 31 * result + (this.selectable ? 1 : 0);
            result = 31 * result + (this.selected ? 1 : 0);
            return result;
        }

        @Override
        public int compareTo(@Nullable ApplicationSelection other) {
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return -1;
            }
            if (this.key.equals((Object)other.key)) {
                return this.compareDisplayName(other);
            }
            if (ApplicationKeys.CORE.equals((Object)this.key)) {
                return 1;
            }
            if (ApplicationKeys.CORE.equals((Object)other.key)) {
                return -1;
            }
            return this.compareDisplayName(other);
        }

        private int compareDisplayName(ApplicationSelection other) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.displayName, other.displayName);
        }

        public String toString() {
            return "ApplicationSelection{key='" + this.key + '\'' + ", displayName='" + this.displayName + '\'' + ", message='" + this.message + '\'' + ", selectable=" + this.selectable + ", selected=" + this.selected + '}';
        }
    }
}

