/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.fugue.Option;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.WorkflowEventHandler;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.WorkflowCopiedEvent;
import com.atlassian.jira.event.WorkflowCreatedEvent;
import com.atlassian.jira.event.WorkflowDeletedEvent;
import com.atlassian.jira.event.WorkflowRenamedEvent;
import com.atlassian.jira.event.WorkflowUpdatedEvent;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.google.common.collect.ImmutableList;

public class WorkflowEventHandlerImpl
implements WorkflowEventHandler {
    @Override
    public RecordRequest onWorkflowCreatedEvent(WorkflowCreatedEvent event) {
        return this.workflowCreated(event.getWorkflow());
    }

    @Override
    public RecordRequest onWorkflowCopiedEvent(WorkflowCopiedEvent event) {
        return this.workflowCreated(event.getNewWorkflow());
    }

    @Override
    public Option<RecordRequest> onWorkflowUpdatedEvent(WorkflowUpdatedEvent event) {
        if (event.getWorkflow().isDraftWorkflow()) {
            return Option.none();
        }
        return Option.some((Object)this.workflowUpdated(event.getOriginalWorkflow(), event.getWorkflow()));
    }

    @Override
    public RecordRequest onDraftWorkflowPublishedEvent(DraftWorkflowPublishedEvent event) {
        return this.workflowUpdated(event.getOriginalWorkflow(), event.getWorkflow());
    }

    @Override
    public RecordRequest onWorkflowRenamedEvent(WorkflowRenamedEvent event) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.renamed").forObject(AssociatedItem.Type.WORKFLOW, event.getNewWorkflowName(), event.getNewWorkflowName()).withChangedValues(new ChangedValuesBuilder().addIfDifferent("common.words.name", event.getOldWorkflowName(), event.getNewWorkflowName()).build());
    }

    @Override
    public RecordRequest onWorkflowDeletedEvent(WorkflowDeletedEvent event) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.deleted").forObject(AssociatedItem.Type.WORKFLOW, event.getWorkflow().getDisplayName(), event.getWorkflow().getName());
    }

    private RecordRequest workflowCreated(JiraWorkflow workflow) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.created").forObject(AssociatedItem.Type.WORKFLOW, workflow.getDisplayName(), workflow.getName()).withChangedValues(this.computeChangedValues(workflow));
    }

    private RecordRequest workflowUpdated(JiraWorkflow fromWorkflow, JiraWorkflow toWorkflow) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.updated").forObject(AssociatedItem.Type.WORKFLOW, toWorkflow.getDisplayName(), toWorkflow.getName()).withChangedValues(this.computeChangedValues(fromWorkflow, toWorkflow));
    }

    private ImmutableList<ChangedValue> computeChangedValues(JiraWorkflow currentWorkflow) {
        return this.computeChangedValues(null, currentWorkflow);
    }

    private ImmutableList<ChangedValue> computeChangedValues(JiraWorkflow originalWorkflow, JiraWorkflow currentWorkflow) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.name", originalWorkflow == null ? null : originalWorkflow.getDisplayName(), currentWorkflow.getDisplayName()).addIfDifferent("common.words.description", originalWorkflow == null ? null : originalWorkflow.getDescription(), currentWorkflow.getDescription());
        return changedValues.build();
    }
}

