/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.user.UserKey;
import java.net.URI;
import java.util.Date;
import javax.annotation.Nullable;

class JiraApplicationAccess
implements ApplicationAccess {
    static final URI URI_MANAGEMENT = URI.create("/secure/admin/ApplicationAccess.jspa");
    private final ApplicationRole role;
    private final ApplicationAuthorizationService authorizationService;
    private final UserManager userManager;
    private final LicenseDetails license;
    private final Date buildDate;

    JiraApplicationAccess(ApplicationRole role, ApplicationAuthorizationService authorizationService, UserManager userManager, LicenseDetails license, Date buildDate) {
        this.role = (ApplicationRole)Assertions.notNull((String)"role", (Object)role);
        this.authorizationService = (ApplicationAuthorizationService)Assertions.notNull((String)"authorizationService", (Object)authorizationService);
        this.userManager = (UserManager)Assertions.notNull((String)"userManager", (Object)userManager);
        this.license = (LicenseDetails)Assertions.notNull((String)"license", (Object)license);
        this.buildDate = (Date)Assertions.notNull((String)"buildDate", (Object)buildDate);
    }

    public ApplicationKey getApplicationKey() {
        return this.role.getKey();
    }

    public Option<Integer> getMaximumUserCount() {
        int seats = this.role.getNumberOfSeats();
        if (seats == -1) {
            return Option.none();
        }
        return Option.some((Object)seats);
    }

    public int getActiveUserCount() {
        return this.authorizationService.getUserCount(this.role.getKey());
    }

    public boolean canUserAccessApplication(@Nullable UserKey userKey) {
        return this.getAccessError(userKey).isEmpty();
    }

    public Option<ApplicationAccess.AccessError> getAccessError(@Nullable UserKey userKey) {
        ApplicationUser user;
        if (this.license.isExpired()) {
            return Option.some((Object)ApplicationAccess.AccessError.EXPIRED);
        }
        if (!this.license.isMaintenanceValidForBuildDate(this.buildDate)) {
            return Option.some((Object)ApplicationAccess.AccessError.VERSION_MISMATCH);
        }
        if (this.authorizationService.isExceeded(this.role.getKey())) {
            return Option.some((Object)ApplicationAccess.AccessError.USERS_EXCEEDED);
        }
        if (userKey == null) {
            user = null;
        } else {
            user = this.userManager.getUserByKey(userKey.getStringValue());
            if (user == null) {
                return Option.some((Object)ApplicationAccess.AccessError.NO_ACCESS);
            }
        }
        if (this.authorizationService.canUseApplication(user, this.role.getKey())) {
            return Option.none();
        }
        return Option.some((Object)ApplicationAccess.AccessError.NO_ACCESS);
    }

    public URI getManagementPage() {
        return URI_MANAGEMENT;
    }
}

