/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.IssueVerifier;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.task.StatefulTaskProgressSink;
import com.atlassian.jira.task.StepTaskProgressSink;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationResult;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationSuccess;
import com.atlassian.jira.web.action.admin.workflow.WorkflowMigrationTerminated;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.migration.WorkflowMigrationMapping;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

class ProjectMigrator<T extends WorkflowScheme> {
    private static final Logger log = Logger.getLogger(ProjectMigrator.class);
    private final Project project;
    private final String projectName;
    private final Long projectId;
    private final T targetScheme;
    private final WorkflowManager workflowManager;
    private final SchemeManager schemeManager;
    private final OfBizDelegator delegator;
    private final User user;
    private final ConstantsManager constantsManager;
    private final I18nHelper i18nHelper;
    private final IssueIndexManager issueIndexManager;
    private final OnCompleteCallback<T> onCompleteCallback;

    ProjectMigrator(Project project, T targetScheme, WorkflowManager workflowManager, SchemeManager schemeManager, OfBizDelegator delegator, User user, ConstantsManager constantsManager, I18nHelper i18nHelper, IssueIndexManager issueIndexManager, OnCompleteCallback<T> onCompleteCallback) {
        this.project = project;
        this.targetScheme = targetScheme;
        this.workflowManager = workflowManager;
        this.schemeManager = schemeManager;
        this.delegator = delegator;
        this.user = user;
        this.constantsManager = constantsManager;
        this.i18nHelper = i18nHelper;
        this.issueIndexManager = issueIndexManager;
        this.onCompleteCallback = onCompleteCallback;
        this.projectName = project.getName();
        this.projectId = project.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowMigrationResult migrate(TaskProgressSink sink, List<GenericValue> typesNeedingMigration, WorkflowMigrationMapping workflowMigrationMapping) throws GenericEntityException, WorkflowException {
        WorkflowMigrationResult workflowMigrationResult;
        Collection<Long> issueIds;
        UtilTimerStack.push((String)"EnterpriseWorkflowMigrationHelper.migrate");
        log.info((Object)("Started workflow migration for project '" + this.projectName + "'."));
        if (sink == null) {
            sink = TaskProgressSink.NULL_SINK;
        }
        StatefulTaskProgressSink migrationSink = new StatefulTaskProgressSink(0L, 100L, sink);
        String currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.verification");
        log.info((Object)("Verifying issues can be moved to another workflow for project '" + this.projectName + "'."));
        migrationSink.makeProgress(0L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.find.affected.issues", this.projectName));
        UtilTimerStack.push((String)"Verifying Issues can be moved to another workflow");
        IssueVerifier issueVerifier = new IssueVerifier();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            issueIds = this.getIssueIds(this.projectId);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while validating issues for workflow migration on project '" + this.projectName + "'."), (Throwable)e);
            errorCollection.addErrorMessage("Error occurred while retrieving issues for verifying for workflow migration: " + e.getMessage());
            UtilTimerStack.pop((String)"Verifying Issues can be moved to another workflow");
            WorkflowMigrationTerminated workflowMigrationTerminated = new WorkflowMigrationTerminated((ErrorCollection)errorCollection);
            UtilTimerStack.pop((String)"EnterpriseWorkflowMigrationHelper.migrate");
            return workflowMigrationTerminated;
        }
        migrationSink.makeProgressIncrement(5L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.found.affected.issues", this.projectName));
        try {
            int numberOfIssues = issueIds.size();
            StepTaskProgressSink issueSink = migrationSink.createStepSinkView(6L, 10L, numberOfIssues);
            int issueCounter = 1;
            for (Long issueId : issueIds) {
                issueSink.makeProgress(issueCounter, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.verify.issue", String.valueOf(issueCounter), String.valueOf(numberOfIssues), this.projectName));
                GenericValue issueGV = this.retrieveIssue(issueId);
                if (issueGV != null) {
                    ErrorCollection possibleErrors = issueVerifier.verifyForMigration(issueGV, typesNeedingMigration, workflowMigrationMapping, false);
                    errorCollection.addErrorCollection(possibleErrors);
                } else {
                    log.debug((Object)("Issue with id '" + issueId + "' not found."));
                }
                ++issueCounter;
            }
            if (errorCollection != null && errorCollection.hasAnyErrors()) {
                log.info((Object)("Enterprise workflow migration failed with invalid issues for project '" + this.projectName + "'."));
                WorkflowMigrationTerminated workflowMigrationTerminated = new WorkflowMigrationTerminated((ErrorCollection)errorCollection);
                return workflowMigrationTerminated;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while verifying issues for workflow migration on project '" + this.projectName + "'."), (Throwable)e);
            errorCollection.addErrorMessage(this.getI18nHelper().getText("admin.errors.workflows.error.occurred.verifying.issues", e.getMessage()));
            WorkflowMigrationTerminated workflowMigrationTerminated = new WorkflowMigrationTerminated((ErrorCollection)errorCollection);
            return workflowMigrationTerminated;
        }
        finally {
            UtilTimerStack.pop((String)"Verifying Issues can be moved to another workflow");
        }
        currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.migration");
        migrationSink.makeProgress(17L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.find.affected.issues", this.projectName));
        UtilTimerStack.push((String)"Refinding issues for new workflow");
        try {
            issueIds = this.getIssueIds(this.projectId);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while retrieving issues for workflow migration of project '" + this.projectName + "'."), (Throwable)e);
            errorCollection.addErrorMessage("Error occurred while retrieving issues for workflow migration. " + e.getMessage());
            workflowMigrationResult = new WorkflowMigrationTerminated((ErrorCollection)errorCollection);
            UtilTimerStack.pop((String)"EnterpriseWorkflowMigrationHelper.migrate");
            return workflowMigrationResult;
        }
        finally {
            UtilTimerStack.pop((String)"Refinding issues for new workflow");
        }
        migrationSink.makeProgressIncrement(5L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.found.affected.issues", this.projectName));
        WorkflowMigrationResult result = this.migrateIssues(issueIds, migrationSink, typesNeedingMigration, workflowMigrationMapping);
        currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.association");
        log.info((Object)("Assigning workflow scheme to project '" + this.projectName + "'."));
        migrationSink.makeProgress(99L, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.assign.workflow", this.getTargetSchemeName(), this.projectName));
        if (result.getResult() == 0) {
            this.complete(this.schemeManager, this.project, this.targetScheme, migrationSink);
        }
        log.info((Object)("Workflow migration complete for project '" + this.projectName + "'."));
        migrationSink.makeProgress(100L, null, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.complete.in.project", this.projectName));
        workflowMigrationResult = result;
        return workflowMigrationResult;
        finally {
            UtilTimerStack.pop((String)"EnterpriseWorkflowMigrationHelper.migrate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private WorkflowMigrationResult migrateIssues(Collection issueIds, StatefulTaskProgressSink percentageSink, List<GenericValue> typesNeedingMigration, WorkflowMigrationMapping workflowMigrationMapping) throws GenericEntityException {
        UtilTimerStack.push((String)"Moving issues to new workflow");
        failedIssues = new HashMap<Long, String>();
        ProjectMigrator.log.info((Object)("Migrating issues in project '" + this.projectName + "' to new workflow."));
        try {
            numberOfIssues = issueIds.size();
            issueCounter = 1L;
            issueSink = percentageSink.createStepSinkView(23L, 75L, numberOfIssues);
            currentSubTask = this.getI18nHelper().getText("admin.selectworkflowscheme.subtask.migration");
            iterator = issueIds.iterator();
            while (iterator.hasNext()) {
                block15: {
                    issueSink.makeProgress(issueCounter, currentSubTask, this.getI18nHelper().getText("admin.selectworkflowscheme.progress.migrate.issue", String.valueOf(issueCounter), String.valueOf(numberOfIssues), this.projectName));
                    issueId = (Long)iterator.next();
                    issueGV = this.retrieveIssue(issueId);
                    if (issueGV == null) break block15;
                    try {
                        currentIssueType = this.getConstantsManager().getIssueType(issueGV.getString("type"));
                        originalWorkflow = this.workflowManager.getWorkflow(issueGV);
                        originalStatus = this.getConstantsManager().getStatus(issueGV.getString("status"));
                        originalWfIdString = issueGV.getLong("workflowId").toString();
                        targetStatus = typesNeedingMigration.contains(currentIssueType) != false ? workflowMigrationMapping.getTargetStatus(issueGV) : this.getConstantsManager().getStatus(issueGV.getString("status"));
                        issueTypeId = issueGV.getString("type");
                        targetWorkflow = this.getTargetWorkflow(issueTypeId);
                        isIssueOnWrongWorkflow = workflowMigrationMapping.isIssueOnWrongWorkflow(issueGV.getLong("id"));
                        if (!isIssueOnWrongWorkflow && targetWorkflow.equals(this.getExistingWorkflow(issueTypeId))) ** GOTO lbl-1000
                        txn = Txn.begin();
                        try {
                            this.issueIndexManager.hold();
                            needsIndex = this.workflowManager.migrateIssueToWorkflowNoReindex(issueGV, targetWorkflow, targetStatus);
                            this.createChangeLog(issueGV, originalWfIdString, originalStatus, originalWorkflow, targetWorkflow, targetStatus);
                            txn.commit();
                            if (needsIndex) {
                                this.reindexIssue(issueGV);
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Exception e) {
                            txn.rollback();
                            throw e;
                        }
                        finally {
                            this.issueIndexManager.release();
                        }
                    }
                    catch (Exception e) {
                        ProjectMigrator.log.error((Object)("Error occurred while migrating issue to a new workflow for project '" + this.projectName + "'."), (Throwable)e);
                        failedIssues.put(issueId, issueGV.getString("key"));
                        if (failedIssues.size() >= 10) {
                            ProjectMigrator.log.info((Object)("Enterprise workflow migration cancelled due to number of errors during issues migration for project '" + this.projectName + "'."));
                            var15_15 = new WorkflowMigrationTerminated(failedIssues);
                            UtilTimerStack.pop((String)"Moving issues to new workflow");
                            return var15_15;
                        }
                        ** break block16
                    }
                }
                ProjectMigrator.log.debug((Object)("Issue with id '" + issueId + "' not found."));
lbl-1000:
                // 4 sources

                {
                    ++issueCounter;
                }
            }
        }
        finally {
            UtilTimerStack.pop((String)"Moving issues to new workflow");
        }
        return new WorkflowMigrationSuccess(failedIssues);
    }

    private JiraWorkflow getExistingWorkflow(String issueTypeId) throws WorkflowException {
        JiraWorkflow workflow = this.workflowManager.getWorkflow(this.projectId, issueTypeId);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow associated with project '" + this.projectId + "', issuetype " + issueTypeId);
        }
        return workflow;
    }

    private JiraWorkflow getTargetWorkflow(String issueTypeId) throws WorkflowException {
        String workflowName = this.targetScheme.getActualWorkflow(issueTypeId);
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        if (workflow == null) {
            throw new WorkflowException("Could not find workflow associated with issuetype " + issueTypeId);
        }
        return workflow;
    }

    private void reindexIssue(GenericValue issueGV) {
        String issueKey = issueGV.getString("key");
        try {
            UtilTimerStack.push((String)("Reindexing issue: " + issueKey));
            ComponentAccessor.getIssueIndexManager().reIndex(issueGV);
            UtilTimerStack.pop((String)("Reindexing issue: " + issueKey));
        }
        catch (IndexException e) {
            log.error((Object)("Error occurred while reindexing issue: " + issueKey), (Throwable)e);
        }
    }

    private void createChangeLog(GenericValue issue, String originalWfIdString, GenericValue originalStatus, JiraWorkflow originalWorkflow, JiraWorkflow targetWorkflow, GenericValue targetStatus) {
        String newwfIdString = issue.getLong("workflowId").toString();
        ArrayList<ChangeItemBean> changeItems = new ArrayList<ChangeItemBean>();
        boolean createChangeLog = false;
        if (!originalWfIdString.equals(newwfIdString)) {
            changeItems.add(new ChangeItemBean("jira", "Workflow", originalWfIdString, originalWorkflow.getName(), newwfIdString, targetWorkflow.getName()));
            createChangeLog = true;
        }
        if (!originalStatus.getString("id").equals(targetStatus.getString("id"))) {
            changeItems.add(new ChangeItemBean("jira", "status", originalStatus.getString("id"), originalStatus.getString("name"), targetStatus.getString("id"), targetStatus.getString("name")));
            createChangeLog = true;
        }
        try {
            if (createChangeLog) {
                ChangeLogUtils.createChangeGroup(this.getUser(), issue, issue, changeItems, true);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred creating change log: " + e), (Throwable)e);
        }
    }

    void complete(SchemeManager schemeManager, Project project, T workflowScheme, StatefulTaskProgressSink migrationSink) throws GenericEntityException {
        this.onCompleteCallback.onComplete(schemeManager, project, workflowScheme, migrationSink);
    }

    private String getTargetSchemeName() {
        if (this.targetScheme == null) {
            return this.getI18nHelper().getText("admin.common.words.default");
        }
        return this.targetScheme.getName();
    }

    User getUser() {
        return this.user;
    }

    I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> getIssueIds(Long projectId) throws GenericEntityException {
        log.debug((Object)"Returning all issues associated with project.");
        OfBizListIterator issueIterator = null;
        ArrayList<Long> issueIds = new ArrayList<Long>();
        try {
            EntityFieldMap cond = new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)projectId), EntityOperator.AND);
            issueIterator = this.delegator.findListIteratorByCondition("Issue", (EntityCondition)cond, null, Arrays.asList("id"), null, null);
            GenericValue issueIdGV = issueIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("id"));
                issueIdGV = issueIterator.next();
            }
        }
        finally {
            if (issueIterator != null) {
                issueIterator.close();
            }
        }
        return issueIds;
    }

    private GenericValue retrieveIssue(Long issueId) throws GenericEntityException {
        return this.delegator.findById("Issue", issueId);
    }

    private ConstantsManager getConstantsManager() {
        return this.constantsManager;
    }

    public static interface OnCompleteCallback<T extends WorkflowScheme> {
        public void onComplete(SchemeManager var1, Project var2, T var3, StatefulTaskProgressSink var4) throws GenericEntityException;
    }
}

