/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class AssignToLeadFunction
extends AbstractJiraFunctionProvider {
    private static final Logger log = Logger.getLogger(AssignToLeadFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) {
        MutableIssue issue = this.getIssue(transientVars);
        String leadKey = null;
        ApplicationUser lead = null;
        boolean componentLead = false;
        if (issue.getComponents() != null && issue.getComponents().size() > 0) {
            componentLead = true;
            GenericValue firstComponent = (GenericValue)issue.getComponents().iterator().next();
            leadKey = firstComponent.getString("lead");
        }
        if (leadKey == null) {
            lead = issue.getProjectObject().getProjectLead();
            String string = leadKey = lead == null ? null : lead.getKey();
        }
        if (leadKey == null) {
            return;
        }
        if (lead == null && (lead = this.getLead(leadKey)) == null) {
            log.error((Object)((componentLead ? "Component" : "Project") + " lead '" + leadKey + "' in project " + issue.getProjectObject().getName() + " does not exist"));
            return;
        }
        log.info((Object)("Automatically setting assignee to lead developer " + leadKey));
        issue.setAssignee(lead.getDirectoryUser());
        if (issue.isCreated()) {
            issue.store();
        }
    }

    ApplicationUser getLead(String userKey) {
        return ComponentAccessor.getUserManager().getUserByKey(userKey);
    }
}

