/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowSchemeStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

class WorkflowSchemeStoreSupport<T extends WorkflowSchemeStore.State> {
    private static final String ALL_ISSUE_TYPES = "0";
    private final OfBizDelegator delegator;
    private final Delegate<T> delegate;

    WorkflowSchemeStoreSupport(OfBizDelegator delegator, Delegate<T> delegate) {
        this.delegator = delegator;
        this.delegate = delegate;
    }

    T create(T state) {
        Assertions.notNull((String)"state", state);
        GenericValue schemeGv = this.delegate.create(state);
        Long newId = schemeGv.getLong("id");
        ArrayList mappingGvs = Lists.newArrayList();
        for (Map.Entry<String, String> mapping : state.getMappings().entrySet()) {
            mappingGvs.add(this.createMapping(newId, mapping.getKey(), mapping.getValue()));
        }
        return this.createStateFrom(schemeGv, mappingGvs);
    }

    T update(T state) {
        Assertions.notNull((String)"state", state);
        Assertions.notNull((String)"state.id", (Object)state.getId());
        GenericValue schemeGv = this.delegator.findByPrimaryKey(this.delegate.schemeTable(), state.getId());
        if (schemeGv == null) {
            throw new DataAccessException("Trying to update workflow scheme that does not exist.");
        }
        this.delegate.update(state, schemeGv);
        List related = this.delegator.getRelated(this.delegate.schemeToEntityRelationship(), schemeGv);
        HashMap schemeMap = Maps.newHashMapWithExpectedSize((int)related.size());
        for (GenericValue value : related) {
            String issueType = value.getString("issuetype");
            if (issueType == null) {
                this.delegator.removeValue(value);
                continue;
            }
            if (ALL_ISSUE_TYPES.equals(issueType)) {
                issueType = null;
            }
            if (schemeMap.put(issueType, value) == null) continue;
            this.delegator.removeValue(value);
        }
        ArrayList enties = Lists.newArrayList();
        for (Map.Entry<String, String> expectedEntry : state.getMappings().entrySet()) {
            String issueType = expectedEntry.getKey();
            String workflowName = expectedEntry.getValue();
            GenericValue currentGv = (GenericValue)schemeMap.remove(issueType);
            if (currentGv == null) {
                enties.add(this.createMapping(state.getId(), expectedEntry.getKey(), workflowName));
                continue;
            }
            String currentWorkflow = currentGv.getString("workflow");
            if (!currentWorkflow.equals(workflowName)) {
                currentGv.setString("workflow", workflowName);
                this.delegator.store(currentGv);
            }
            enties.add(currentGv);
        }
        for (GenericValue genericValue : schemeMap.values()) {
            this.delegator.removeValue(genericValue);
        }
        return this.createStateFrom(schemeGv, enties);
    }

    public boolean delete(T state) {
        Assertions.notNull((String)"state", state);
        Assertions.notNull((String)"state.id", (Object)state.getId());
        return this.delete(state.getId());
    }

    boolean delete(long id) {
        GenericValue schemeGv = this.delegator.findByPrimaryKey(this.delegate.schemeTable(), Long.valueOf(id));
        if (schemeGv != null) {
            this.delegator.removeRelated(this.delegate.schemeToEntityRelationship(), schemeGv);
            this.delegator.removeValue(schemeGv);
            return true;
        }
        return false;
    }

    T get(long id) {
        GenericValue schemeGv = this.getGenericValue(id);
        return this.createStateFrom(schemeGv);
    }

    GenericValue getGenericValue(long id) {
        return this.delegator.findByPrimaryKey(this.delegate.schemeTable(), Long.valueOf(id));
    }

    Iterable<T> getAll() {
        List allGvs = this.delegator.findAll(this.delegate.schemeTable());
        return this.toDraftWorkflowSchemeStates(allGvs);
    }

    List<T> toDraftWorkflowSchemeStates(List<GenericValue> gvs) {
        ArrayList states = Lists.newArrayListWithExpectedSize((int)gvs.size());
        for (GenericValue schemeGv : gvs) {
            states.add(this.createStateFrom(schemeGv));
        }
        return states;
    }

    boolean renameWorkflow(String oldName, String newName) {
        return this.delegator.bulkUpdateByAnd(this.delegate.entityTable(), (Map)ImmutableMap.of((Object)"workflow", (Object)newName), (Map)ImmutableMap.of((Object)"workflow", (Object)oldName)) > 0;
    }

    Iterable<T> getSchemesUsingWorkflow(JiraWorkflow workflow) {
        if (workflow.isSystemWorkflow()) {
            throw new IllegalArgumentException("Can't get schemes for system workflow");
        }
        LinkedList<T> states = new LinkedList<T>();
        HashSet<Long> schemeIds = new HashSet<Long>();
        List schemeEntities = this.delegator.findByAnd(this.delegate.entityTable(), (Map)ImmutableMap.of((Object)"workflow", (Object)workflow.getName()));
        for (GenericValue schemeEntity : schemeEntities) {
            Long schemeId = schemeEntity.getLong("scheme");
            if (schemeIds.contains(schemeId)) continue;
            states.add(this.get(schemeId));
            schemeIds.add(schemeId);
        }
        return states;
    }

    private GenericValue createMapping(Long schemeId, String issueType, String workflow) {
        FieldMap entityMap = FieldMap.build((String)"scheme", (Object)schemeId);
        entityMap.add("issuetype", (Object)(issueType == null ? ALL_ISSUE_TYPES : issueType));
        entityMap.add("workflow", (Object)workflow);
        return this.delegator.createValue(this.delegate.entityTable(), (Map)entityMap);
    }

    T createStateFrom(GenericValue schemeGv) {
        if (schemeGv == null) {
            return null;
        }
        return this.createStateFrom(schemeGv, this.delegator.getRelated(this.delegate.schemeToEntityRelationship(), schemeGv));
    }

    private T createStateFrom(GenericValue schemeGv, Iterable<GenericValue> entities) {
        HashMap mappings = Maps.newHashMap();
        for (GenericValue value : entities) {
            String issueType = value.getString("issuetype");
            String workflowName = value.getString("workflow");
            if (issueType == null) continue;
            if (ALL_ISSUE_TYPES.equals(issueType)) {
                issueType = null;
            }
            mappings.put(issueType, workflowName);
        }
        return this.delegate.get(schemeGv, mappings);
    }

    static interface Delegate<T extends WorkflowSchemeStore.State> {
        public String schemeTable();

        public String entityTable();

        public String schemeToEntityRelationship();

        public GenericValue create(T var1);

        public void update(T var1, GenericValue var2);

        public T get(GenericValue var1, Map<String, String> var2);
    }

    private static class EntityTable {
        private EntityTable() {
        }

        private static class Columns {
            private static final String WORKFLOW_SCHEME = "scheme";
            private static final String WORKFLOW_NAME = "workflow";
            private static final String ISSUE_TYPE = "issuetype";

            private Columns() {
            }
        }
    }

    private static class SchemeTable {
        private SchemeTable() {
        }

        private static class Columns {
            private static final String ID = "id";

            private Columns() {
            }
        }
    }
}

