/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.AssignableWorkflowSchemeStore;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowSchemeStateBuilderTemplate;
import com.atlassian.jira.workflow.WorkflowSchemeStoreSupport;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class OfBizAssignableWorkflowSchemeStore
implements AssignableWorkflowSchemeStore {
    private final WorkflowSchemeStoreSupport<AssignableWorkflowSchemeStore.AssignableState> support;

    public OfBizAssignableWorkflowSchemeStore(OfBizDelegator delegator) {
        this.support = new WorkflowSchemeStoreSupport<AssignableWorkflowSchemeStore.AssignableState>(delegator, new SupportDelegate(delegator));
    }

    @Override
    public AssignableWorkflowSchemeStore.AssignableState create(AssignableWorkflowSchemeStore.AssignableState state) {
        return this.support.create(state);
    }

    @Override
    public AssignableWorkflowSchemeStore.AssignableState update(AssignableWorkflowSchemeStore.AssignableState state) {
        return this.support.update(state);
    }

    @Override
    public boolean delete(long id) {
        return this.support.delete(id);
    }

    @Override
    public boolean delete(AssignableWorkflowSchemeStore.AssignableState state) {
        Assertions.notNull((String)"state", (Object)state);
        Assertions.notNull((String)"state.id", (Object)state.getId());
        return this.delete(state.getId());
    }

    @Override
    public AssignableWorkflowSchemeStore.AssignableState get(long id) {
        return this.support.get(id);
    }

    @Override
    public Iterable<AssignableWorkflowSchemeStore.AssignableState> getAll() {
        return this.support.getAll();
    }

    @Override
    public boolean renameWorkflow(String oldName, String newName) {
        return this.support.renameWorkflow(oldName, newName);
    }

    @Override
    public Iterable<AssignableWorkflowSchemeStore.AssignableState> getSchemesUsingWorkflow(JiraWorkflow jiraWorkflow) {
        return this.support.getSchemesUsingWorkflow(jiraWorkflow);
    }

    @Override
    public AssignableWorkflowSchemeStore.AssignableState.Builder builder() {
        return new DefaultWorkflowSchemeStateBuilder();
    }

    private static class SupportDelegate
    implements WorkflowSchemeStoreSupport.Delegate<AssignableWorkflowSchemeStore.AssignableState> {
        private final OfBizDelegator delegator;

        private SupportDelegate(OfBizDelegator delegator) {
            this.delegator = delegator;
        }

        @Override
        public String schemeTable() {
            return "WorkflowScheme";
        }

        @Override
        public String entityTable() {
            return "WorkflowSchemeEntity";
        }

        @Override
        public String schemeToEntityRelationship() {
            return "ChildWorkflowSchemeEntity";
        }

        @Override
        public GenericValue create(AssignableWorkflowSchemeStore.AssignableState state) {
            FieldMap fieldMap = FieldMap.build((String)"name", (Object)state.getName());
            fieldMap.add("description", (Object)state.getDescription());
            return this.delegator.createValue("WorkflowScheme", (Map)fieldMap);
        }

        @Override
        public void update(AssignableWorkflowSchemeStore.AssignableState state, GenericValue schemeGv) {
            schemeGv.set("name", (Object)state.getName());
            schemeGv.set("description", (Object)state.getDescription());
            this.delegator.store(schemeGv);
        }

        @Override
        public AssignableWorkflowSchemeStore.AssignableState get(GenericValue schemeGv, Map<String, String> map) {
            Long id = schemeGv.getLong("id");
            String name = schemeGv.getString("name");
            String description = schemeGv.getString("description");
            return new AssignableWorkflowSchemeStateImpl(id, name, description, map);
        }
    }

    private static class AssignableWorkflowSchemeStateImpl
    implements AssignableWorkflowSchemeStore.AssignableState {
        private final Long id;
        private final String name;
        private final String description;
        private final Map<String, String> issueTypeToWorkflow;

        private AssignableWorkflowSchemeStateImpl(Long id, String name, String description, Map<String, String> issueTypeToWorkflow) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.issueTypeToWorkflow = Collections.unmodifiableMap(Maps.newHashMap(issueTypeToWorkflow));
        }

        @Override
        public Long getId() {
            return this.id;
        }

        @Override
        public Map<String, String> getMappings() {
            return this.issueTypeToWorkflow;
        }

        @Override
        public String getDefaultWorkflow() {
            return this.issueTypeToWorkflow.get(null);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public AssignableWorkflowSchemeStore.AssignableState.Builder builder() {
            return new DefaultWorkflowSchemeStateBuilder(this);
        }
    }

    private static class DefaultWorkflowSchemeStateBuilder
    extends WorkflowSchemeStateBuilderTemplate<AssignableWorkflowSchemeStore.AssignableState.Builder>
    implements AssignableWorkflowSchemeStore.AssignableState.Builder {
        private String name;
        private String description;

        DefaultWorkflowSchemeStateBuilder() {
        }

        DefaultWorkflowSchemeStateBuilder(AssignableWorkflowSchemeStore.AssignableState state) {
            super(state);
            this.name = state.getName();
            this.description = state.getDescription();
        }

        @Override
        AssignableWorkflowSchemeStore.AssignableState.Builder getThis() {
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public AssignableWorkflowSchemeStore.AssignableState.Builder setName(String name) {
            if ((name = StringUtils.stripToNull((String)name)) == null) {
                throw new IllegalArgumentException("Scheme name cannot be null or empty.");
            }
            if (name.length() > 255) {
                throw new IllegalArgumentException("Scheme name must be less than 255 characters.");
            }
            this.name = name;
            return this;
        }

        @Override
        public AssignableWorkflowSchemeStore.AssignableState.Builder setDescription(String description) {
            this.description = StringUtils.stripToNull((String)description);
            return this;
        }

        @Override
        public AssignableWorkflowSchemeStore.AssignableState build() {
            return new AssignableWorkflowSchemeStateImpl(this.getId(), this.name, this.description, this.getMappings());
        }
    }

    private static class EntityTable {
        private static final String ENTITY = "WorkflowSchemeEntity";

        private EntityTable() {
        }
    }

    private static class SchemeTable {
        private static final String ENTITY = "WorkflowScheme";
        private static final String ENTITY_RELATIONSHIP = "ChildWorkflowSchemeEntity";

        private SchemeTable() {
        }

        private static class Columns {
            private static final String ID = "id";
            private static final String NAME = "name";
            private static final String DESCRIPTION = "description";

            private Columns() {
            }
        }
    }
}

