/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.mime.MimeManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileIconBean {
    public static final List<FileIcon> DEFAULT_FILE_ICONS;
    private final List<FileIcon> mimeTypes;
    private final MimeManager mimeManager;

    public FileIconBean(List<FileIcon> mimeTypes, MimeManager mimeManager) {
        this.mimeTypes = Collections.unmodifiableList(new ArrayList<FileIcon>(mimeTypes));
        this.mimeManager = mimeManager;
    }

    public FileIcon getFileIcon(String fileName, String mimeType) {
        for (FileIcon fileIcon : this.mimeTypes) {
            if (fileIcon.getMimeType().equals(mimeType)) {
                return fileIcon;
            }
            if (fileName != null && fileName.trim().toLowerCase().endsWith(fileIcon.getFileExtension())) {
                return fileIcon;
            }
            if (!fileIcon.getMimeType().equals(this.mimeManager.getSuggestedMimeType(fileName))) continue;
            return fileIcon;
        }
        return null;
    }

    static {
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        builder.add((Object)new FileIcon(".pdf", "application/pdf", "pdf.gif", "PDF File"));
        builder.add((Object)new FileIcon(".gif", "image/gif", "image.gif", "GIF File"));
        builder.add((Object)new FileIcon(".png", "image/png", "image.gif", "PNG File"));
        builder.add((Object)new FileIcon(".jpeg", "image/jpeg", "image.gif", "JPEG File"));
        builder.add((Object)new FileIcon(".xml", "text/xml", "xml.gif", "XML File"));
        builder.add((Object)new FileIcon(".html", "text/html", "html.gif", "HTML File"));
        builder.add((Object)new FileIcon(".java", "", "java.gif", "Java Source File"));
        builder.add((Object)new FileIcon(".jar", "", "java.gif", "Java Archive File"));
        builder.add((Object)new FileIcon(".txt", "text/plain", "text.gif", "Text File"));
        builder.add((Object)new FileIcon(".zip", "application/zip", "zip.gif", "Zip Archive"));
        builder.add((Object)new FileIcon(".gz", "application/x-gzip-compressed", "zip.gif", "GZip Archive"));
        String[] wordExtensions = new String[]{".doc", ".docx", "docm", "dotx", "dotm"};
        String[] excelExtensions = new String[]{".xls", "xlsx", "xlsm", "xltx", "xltm", "xlsb", "xlam"};
        String[] powerpointExtensions = new String[]{"pptx", "pptm", "potx", "potm", "ppam", "ppsx", "ppsm"};
        for (String wordExtension : wordExtensions) {
            builder.add((Object)new FileIcon(wordExtension, "application/msword", "word.gif", "Microsoft Word"));
        }
        for (String excelExtension : excelExtensions) {
            builder.add((Object)new FileIcon(excelExtension, "application/vnd.ms-excel", "excel.gif", "Microsoft Excel"));
        }
        for (String powerpointExtension : powerpointExtensions) {
            builder.add((Object)new FileIcon(powerpointExtension, "application/vnd.ms-powerpoint", "powerpoint.gif", "Microsoft PowerPoint"));
        }
        DEFAULT_FILE_ICONS = builder.asList();
    }

    public static final class FileIcon {
        private final String fileExtension;
        private final String mimeType;
        private final String icon;
        private final String altText;

        public FileIcon(String fileExtension, String mimeType, String icon, String altText) {
            this.fileExtension = fileExtension;
            this.mimeType = mimeType;
            this.icon = icon;
            this.altText = altText;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getAltText() {
            return this.altText;
        }
    }
}

