/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.rpc;

import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.web.servlet.rpc.XmlRpcRequestProcessor;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XmlRpcServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ApplicationProperties applicationProperties = (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
        if (applicationProperties.getOption("jira.option.rpc.allow")) {
            if (applicationProperties.getString("jira.setup") != null) {
                OpTimer timer = Instrumentation.pullTimer(InstrumentationName.XMLRPC_REQUESTS);
                try {
                    ActionContextKit.resetContext();
                    this.executeRequest(request, response);
                }
                finally {
                    ActionContextKit.resetContext();
                    timer.end();
                }
            }
        } else {
            throw new ServletException("Remote API not activated for this JIRA installation.");
        }
    }

    private void executeRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        byte[] result = ((XmlRpcRequestProcessor)ComponentAccessor.getComponentOfType(XmlRpcRequestProcessor.class)).process((InputStream)request.getInputStream());
        response.setContentType("text/xml");
        response.setContentLength(result.length);
        ServletOutputStream out = response.getOutputStream();
        out.write(result);
        out.flush();
    }
}

