/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.pagebuilder;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterCallContextImpl;
import com.atlassian.jira.web.filters.steps.FilterStep;
import com.atlassian.jira.web.filters.steps.pagebuilder.PageBuilderResponseWrapper;
import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.jira.web.pagebuilder.PageBuilderServiceSpi;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.sitemesh.Content;
import com.opensymphony.sitemesh.compatability.HTMLPage2Content;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageBuilderStep
implements FilterStep {
    private static final String FILTER_LOG_MSG = "PageBuilderFilter[%s].filter decorated servlet path [%s] ";
    private static final Logger log = LoggerFactory.getLogger(PageBuilderStep.class);
    private PageBuilderResponseWrapper responseWrapper;
    private HttpServletResponse wrappedResponse;

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug(String.format(FILTER_LOG_MSG, ctx.getFilterConfig().getFilterName(), ctx.getHttpServletRequest().getServletPath()));
        }
        this.responseWrapper = new PageBuilderResponseWrapper(ctx.getHttpServletResponse());
        this.wrappedResponse = ctx.getHttpServletResponse();
        this.getPageBuilderServiceSpi().initForRequest(ctx.getHttpServletRequest(), ctx.getHttpServletResponse(), this.responseWrapper, ctx.getFilterConfig().getServletContext());
        return new FilterCallContextImpl(ctx.getHttpServletRequest(), (HttpServletResponse)this.responseWrapper, ctx.getFilterChain(), ctx.getFilterConfig());
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext ctx) {
        try {
            if (this.responseWrapper.isBuffering()) {
                Page page = this.responseWrapper.getBuffer().parse();
                this.renderDecoratablePage((Content)new HTMLPage2Content((HTMLPage)page));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error parsing decorated page '" + ctx.getHttpServletRequest().getServletPath() + "'", ex);
        }
        finally {
            this.getPageBuilderServiceSpi().clearForRequest();
        }
        return new FilterCallContextImpl(ctx.getHttpServletRequest(), this.wrappedResponse, ctx.getFilterChain(), ctx.getFilterConfig());
    }

    private void renderDecoratablePage(final Content content) {
        this.getPageBuilderServiceSpi().getSpi().finish(new DecoratablePage(){

            @Override
            public String getTitle() {
                return content.getTitle();
            }

            @Override
            public String getMetaProperty(String key) {
                return content.getProperty("meta." + key);
            }

            @Override
            public String getBodyTagProperty(String key) {
                return content.getProperty("body." + key);
            }

            @Override
            public String getPageProperty(String key) {
                return content.getProperty("page." + key);
            }

            @Override
            public void writeHead(Writer writer) {
                try {
                    content.writeHead(writer);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void writeBody(Writer writer) {
                try {
                    content.writeBody(writer);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
    }

    private PageBuilderServiceSpi getPageBuilderServiceSpi() {
        return (PageBuilderServiceSpi)ComponentAccessor.getComponentOfType(PageBuilderServiceSpi.class);
    }
}

