/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.pagebuilder;

import com.atlassian.jira.web.pagebuilder.DecoratorListener;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.filter.Buffer;
import com.opensymphony.module.sitemesh.filter.HttpContentType;
import com.opensymphony.module.sitemesh.parser.HTMLPageParser;
import com.opensymphony.module.sitemesh.scalability.NoopScalabilitySupport;
import com.opensymphony.module.sitemesh.scalability.ScalabilitySupport;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

class PageBuilderResponseWrapper
extends HttpServletResponseWrapper
implements DecoratorListener {
    private Buffer buffer;
    private boolean contentHasBeenWritten;
    private boolean decoratorHasBeenSet;

    PageBuilderResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void onDecoratorSet() {
        if (this.contentHasBeenWritten) {
            throw new IllegalStateException("Cannot set decorator after content type has been written");
        }
        this.decoratorHasBeenSet = true;
    }

    public PrintWriter getWriter() throws IOException {
        this.contentHasBeenWritten = true;
        if (null != this.buffer) {
            return this.buffer.getWriter();
        }
        return this.getResponse().getWriter();
    }

    public void setContentType(String type) {
        if (this.decoratorHasBeenSet && type != null) {
            HttpContentType httpContentType = new HttpContentType(type);
            this.buffer = new Buffer((PageParser)new HTMLPageParser(), httpContentType.getEncoding(), (ScalabilitySupport)new NoopScalabilitySupport());
        }
        super.setContentType(type);
    }

    Buffer getBuffer() {
        return this.buffer;
    }

    boolean isBuffering() {
        return null != this.buffer;
    }
}

