/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.webwork.actions.ActionConfiguration;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.dispatcher.JiraSoyViewDispatcher;
import com.atlassian.jira.web.dispatcher.JiraVelocityViewDispatcher;
import com.atlassian.seraph.util.RedirectUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import webwork.config.util.ActionInfo;
import webwork.dispatcher.ActionResult;
import webwork.util.ServletValueStack;

class JiraWebworkViewDispatcher {
    private static final Logger log = LoggerFactory.getLogger(JiraWebworkViewDispatcher.class);
    public static final Supplier<String> ASSERTION_CANT_BE_NONE = new Supplier<String>(){

        public String get() {
            return "This cannot not be Option.none() at this stage";
        }
    };
    private final JiraSoyViewDispatcher soyViewDispatcher = new JiraSoyViewDispatcher();
    private final JiraVelocityViewDispatcher velocityViewDispatcher = new JiraVelocityViewDispatcher();

    JiraWebworkViewDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean doCleanup, ActionResult ar, String actionAlias) throws ServletException, IOException {
        if (this.permissionViolationCheckHandled(ar, httpServletRequest, httpServletResponse, doCleanup)) {
            return;
        }
        String actionView = ar.getView().toString();
        String actionResult = ar.getResult();
        log.debug("Action Result {} --> View Name: {}", (Object)actionResult, (Object)actionView);
        Option<ActionInfo.ViewInfo> viewInfo = this.determineViewInfo(ar, actionAlias);
        try {
            if (this.isSoyView(viewInfo)) {
                this.dispatchViaSoyView(httpServletResponse, ar, viewInfo);
            } else if (this.isVelocityView(viewInfo)) {
                this.dispatchViaVelocityView(httpServletRequest, httpServletResponse, ar, viewInfo);
            } else {
                this.dispatchViaHttpView(httpServletRequest, httpServletResponse, ar, viewInfo);
            }
        }
        finally {
            this.cleanUpStack(httpServletRequest, doCleanup);
        }
    }

    private Option<ActionInfo.ViewInfo> determineViewInfo(ActionResult ar, String actionAlias) {
        Option<ActionInfo.ViewInfo> viewInfo = this.getViewInfo(actionAlias, ar.getResult());
        if (viewInfo.isEmpty() && "input".equals(ar.getResult())) {
            viewInfo = this.getViewInfo(actionAlias, "error");
        }
        return viewInfo;
    }

    private void dispatchViaHttpView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionResult actionResult, Option<ActionInfo.ViewInfo> viewInfo) throws ServletException, IOException {
        String view = actionResult.getView().toString();
        this.forwardToHttpView(httpServletRequest, httpServletResponse, view, this.getRequestDispatcher(httpServletRequest, view));
    }

    private void dispatchViaVelocityView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ActionResult actionResult, Option<ActionInfo.ViewInfo> viewInfoOption) throws ServletException, IOException {
        this.velocityViewDispatcher.dispatch(httpServletRequest, httpServletResponse, actionResult, (ActionInfo.ViewInfo)viewInfoOption.get());
    }

    private void forwardToHttpView(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String view, RequestDispatcher dispatcher) throws ServletException, IOException {
        if (!httpServletResponse.isCommitted() && httpServletRequest.getAttribute("javax.servlet.include.servlet_path") == null) {
            httpServletRequest.setAttribute("webwork.view_uri", (Object)view);
            httpServletRequest.setAttribute("webwork.request_uri", (Object)httpServletRequest.getRequestURI());
            dispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            dispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private RequestDispatcher getRequestDispatcher(HttpServletRequest httpServletRequest, String view) throws ServletException {
        RequestDispatcher dispatcher = httpServletRequest.getRequestDispatcher(view);
        if (dispatcher == null) {
            throw new ServletException(String.format("No presentation file with name: '%s' found!", view));
        }
        return dispatcher;
    }

    private void dispatchViaSoyView(HttpServletResponse httpServletResponse, ActionResult ar, Option<ActionInfo.ViewInfo> viewInfo) throws ServletException, IOException {
        this.soyViewDispatcher.dispatch(httpServletResponse, ar, (ActionInfo.ViewInfo)viewInfo.getOrError(ASSERTION_CANT_BE_NONE));
    }

    private boolean isSoyView(Option<ActionInfo.ViewInfo> viewInfo) {
        return "soy".equals(this.getAttrValue(viewInfo, "type").getOrNull());
    }

    private boolean isVelocityView(Option<ActionInfo.ViewInfo> viewInfo) {
        boolean isVelocity = false;
        if (viewInfo.isDefined()) {
            isVelocity = "velocity".equals(this.getAttrValue(viewInfo, "type").getOrNull());
            isVelocity |= ((ActionInfo.ViewInfo)viewInfo.get()).getViewValue().endsWith(".vm");
        }
        return isVelocity;
    }

    private void cleanUpStack(HttpServletRequest httpServletRequest, boolean doCleanup) {
        if (doCleanup) {
            httpServletRequest.setAttribute("webwork.valuestack.head", ServletValueStack.getStack((ServletRequest)httpServletRequest).popValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean permissionViolationCheckHandled(ActionResult ar, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean doCleanup) {
        String result;
        if (!this.isUserLoggedIn() && ("permissionviolation".equals(result = ar.getResult()) || "securitybreach".equals(result))) {
            String loginUrl = RedirectUtils.getLoginUrl((HttpServletRequest)httpServletRequest);
            try {
                httpServletResponse.sendRedirect(loginUrl);
            }
            catch (IOException e) {
                log.error("Unable to redirect permission violation to " + loginUrl);
            }
            finally {
                this.cleanUpStack(httpServletRequest, doCleanup);
            }
            return true;
        }
        return false;
    }

    private Option<ActionInfo.ViewInfo> getViewInfo(String actionAlias, String actionResult) {
        ActionConfiguration.Entry actionConfiguration = this.getActionConfiguration(actionAlias);
        ActionInfo actionInfo = actionConfiguration.getActionInfo();
        for (ActionInfo.ViewInfo viewInfo : actionInfo.getViews()) {
            if (!viewInfo.getViewName().equals(actionResult)) continue;
            return Option.some((Object)viewInfo);
        }
        return Option.none();
    }

    private Option<String> getAttrValue(Option<ActionInfo.ViewInfo> viewInfo, final String attrName) {
        return viewInfo.map((Function)new Function<ActionInfo.ViewInfo, String>(){

            public String apply(ActionInfo.ViewInfo input) {
                return input.getAttributeValue(attrName);
            }
        });
    }

    public static boolean isFromCore(String pluginSource) {
        return pluginSource == null || pluginSource.endsWith("WEB-INF/classes/actions.xml");
    }

    @VisibleForTesting
    boolean isUserLoggedIn() {
        return ((JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class)).getUser() != null;
    }

    @VisibleForTesting
    ActionConfiguration.Entry getActionConfiguration(String actionAlias) {
        return ((ActionConfiguration)ComponentAccessor.getComponent(ActionConfiguration.class)).getActionCommand(actionAlias);
    }
}

