/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.io.StringWriter;
import java.io.Writer;

public class Error404
extends JiraWebActionSupport {
    private final WebResourceManager webResourceManager;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;

    public Error404(WebResourceManager webResourceManager, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor) {
        this.webResourceManager = webResourceManager;
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
    }

    protected String doExecute() throws Exception {
        this.webResourceManager.requireResourcesForContext("atl.error");
        this.webResourceManager.requireResourcesForContext("jira.error");
        this.webResourceManager.requireResourcesForContext("atl.global");
        this.webResourceManager.requireResourcesForContext("jira.global");
        return "success";
    }

    @ActionViewData
    public String getResources() {
        StringWriter stringWriter = new StringWriter();
        this.webResourceManager.includeResources((Writer)stringWriter, UrlMode.ABSOLUTE);
        return stringWriter.toString();
    }

    @ActionViewData
    public String getOriginalURL() {
        String attribute = (String)this.getHttpRequest().getAttribute("javax.servlet.forward.servlet_path");
        if (attribute == null) {
            attribute = this.getHttpRequest().getRequestURI().substring(this.getHttpRequest().getContextPath().length());
        }
        String baseUrl = this.applicationProperties.getDefaultBackedString("jira.baseurl");
        return baseUrl + attribute;
    }

    @ActionViewData
    public String getJiraTitle() {
        return this.applicationProperties.getDefaultBackedString("jira.title");
    }

    @ActionViewData
    public String getFooterContent() {
        FooterModuleDescriptor footer = (FooterModuleDescriptor)this.pluginAccessor.getEnabledPluginModule("jira.footer:standard-footer");
        if (footer != null) {
            return ((PluggableFooter)footer.getModule()).getFullFooterHtml(this.getHttpRequest());
        }
        return "";
    }
}

