/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.SetupAdminUserSessionStorage;
import com.atlassian.jira.web.action.setup.SetupLicenseSessionStorage;
import com.google.common.base.Strings;

public class SetupAdminAccount
extends AbstractSetupAction {
    String username;
    String fullname;
    String firstname;
    String lastname;
    String email;
    String password;
    String confirm;
    private String EXISTING_ADMINS = "existingadmins";
    private final UserService userService;
    private final GroupManager groupManager;
    private final UserUtil userUtil;
    private UserService.CreateUserValidationResult result;

    public SetupAdminAccount(UserService userService, GroupManager groupManager, UserUtil userUtil, FileFactory fileFactory) {
        super(fileFactory);
        this.userService = userService;
        this.groupManager = groupManager;
        this.userUtil = userUtil;
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.userUtil.getJiraAdministrators().size() > 0) {
            return this.EXISTING_ADMINS;
        }
        this.prePopulateFields();
        return super.doDefault();
    }

    private void prePopulateFields() {
        SetupLicenseSessionStorage sessionStorage = (SetupLicenseSessionStorage)this.request.getSession().getAttribute(SetupLicenseSessionStorage.SESSION_KEY);
        this.request.getSession().removeAttribute(SetupLicenseSessionStorage.SESSION_KEY);
        if (sessionStorage != null) {
            this.firstname = Strings.nullToEmpty((String)sessionStorage.getFirstName());
            this.lastname = Strings.nullToEmpty((String)sessionStorage.getLastName());
            this.email = Strings.nullToEmpty((String)sessionStorage.getEmail());
            if (Strings.isNullOrEmpty((String)this.fullname)) {
                this.fullname = (this.firstname + " " + this.lastname).trim();
            }
            if (!Strings.isNullOrEmpty((String)this.firstname) && !Strings.isNullOrEmpty((String)this.lastname)) {
                this.username = (this.firstname.charAt(0) + this.lastname).replaceAll("\\s", "").toLowerCase();
            }
        }
    }

    protected void doValidation() {
        if (this.setupAlready()) {
            return;
        }
        this.result = this.userService.validateCreateUserForSetup(this.getLoggedInUser(), this.getUsername(), this.getPassword(), this.getConfirm(), this.getEmail(), this.getFullname());
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
    }

    protected String doExecute() {
        block12: {
            if (this.setupAlready()) {
                return "setupalready";
            }
            User administrator = null;
            try {
                if (!this.userUtil.getJiraAdministrators().isEmpty()) {
                    return this.EXISTING_ADMINS;
                }
                try {
                    administrator = this.userService.createUserNoNotification(this.result);
                }
                catch (PermissionException e) {
                    this.addErrorMessage(this.getText("signup.error.group.database.immutable", this.result.getUsername()));
                }
                Group groupAdmins = this.getOrCreateGroup("jira-administrators");
                Group groupDevelopers = this.getOrCreateGroup("jira-developers");
                Group groupUsers = this.getOrCreateGroup("jira-users");
                if (administrator == null || groupAdmins == null || groupDevelopers == null || groupUsers == null) break block12;
                try {
                    this.groupManager.addUserToGroup(administrator, groupAdmins);
                    this.groupManager.addUserToGroup(administrator, groupDevelopers);
                    this.groupManager.addUserToGroup(administrator, groupUsers);
                }
                catch (GroupNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (UserNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (OperationNotPermittedException e) {
                    throw new RuntimeException(e);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
                GlobalPermissionManager globalPermissionManager = ComponentAccessor.getGlobalPermissionManager();
                if (!globalPermissionManager.getGroupNames(0).contains("jira-administrators")) {
                    globalPermissionManager.addPermission(0, "jira-administrators");
                }
            }
            catch (CreateException e) {
                throw new RuntimeException(e);
            }
        }
        this.request.getSession().setAttribute(SetupAdminUserSessionStorage.SESSION_KEY, (Object)new SetupAdminUserSessionStorage(this.result.getUsername()));
        return this.getResult();
    }

    private Group getOrCreateGroup(String groupName) {
        Group group = this.groupManager.getGroup(groupName);
        if (group != null) {
            return group;
        }
        try {
            return this.groupManager.createGroup(groupName);
        }
        catch (OperationNotPermittedException e) {
            this.addErrorMessage(this.getText("signup.error.group.database.immutable", groupName));
        }
        catch (InvalidGroupException e) {
            this.addErrorMessage(this.getText("signup.error.group.database.immutable", groupName));
        }
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }
}

