/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.index.ProjectReindexService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.project.ViewProject;
import webwork.action.ActionContext;

public class EditProject
extends ViewProject {
    private final ProjectService projectService;
    private AvatarManager avatarManager;
    private final UserManager userManager;
    private final ProjectDescriptionRenderer projectDescriptionRenderer;
    private final UserKeyService userKeyService;
    private final DarkFeatures darkFeatures;
    private final ProjectReindexService projectReindexService;
    private String originalKey;
    private boolean keyEdited;

    public EditProject(ProjectService projectService, AvatarManager avatarManager, UserManager userManager, UserKeyService userKeyService, FeatureManager featureManager, ProjectReindexService projectReindexService) {
        this.projectService = projectService;
        this.avatarManager = avatarManager;
        this.userManager = userManager;
        this.userKeyService = userKeyService;
        this.projectReindexService = projectReindexService;
        this.darkFeatures = featureManager.getDarkFeatures();
        this.projectDescriptionRenderer = (ProjectDescriptionRenderer)ComponentAccessor.getComponentOfType(ProjectDescriptionRenderer.class);
    }

    @Override
    public String doDefault() throws Exception {
        if (this.getProject() == null) {
            return this.handleProjectDoesNotExist();
        }
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        this.setName(this.getProject().getString("name"));
        this.setLead(this.userKeyService.getUsernameForKey(this.getProject().getString("lead")));
        this.setKeyEdited(false);
        String key = this.getProject().getString("key");
        this.setKey(key);
        this.setOriginalKey(key);
        this.setUrl(this.getProject().getString("url"));
        this.setDescription(this.getProject().getString("description"));
        this.setAssigneeType(this.getProject().getLong("assigneetype"));
        return "input";
    }

    private String handleProjectDoesNotExist() throws Exception {
        if (this.hasAdminPermission()) {
            this.setName("???");
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return super.doDefault();
        }
        return "securitybreach";
    }

    protected ProjectService.UpdateProjectValidationResult getUpdateProjectValidationResult() {
        Project projectObject = this.getProjectObject();
        if (this.isProjectKeyRenameAllowed() && this.isKeyEdited()) {
            return this.projectService.validateUpdateProject(this.getLoggedInApplicationUser(), this.getProjectObject(), this.getName(), this.getKey(), this.getDescription(), projectObject.getProjectLead(), this.getUrl(), projectObject.getAssigneeType(), null);
        }
        return this.projectService.validateUpdateProject(this.getLoggedInApplicationUser(), this.getName(), projectObject.getKey(), this.getDescription(), projectObject.getProjectLead(), this.getUrl(), projectObject.getAssigneeType());
    }

    @Override
    protected void doValidation() {
        if (this.getProject() == null) {
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            return;
        }
        ProjectService.UpdateProjectValidationResult result = this.getUpdateProjectValidationResult();
        if (!result.isValid()) {
            this.mapErrorCollection(result.getErrorCollection());
        }
        if (result.isKeyChanged() && !this.projectReindexService.isReindexPossible(this.getProjectObject())) {
            this.addError("key", this.getText("admin.errors.project.key.other.reindex"));
        }
        super.doValidation();
    }

    public String getAvatarUrl() {
        return ActionContext.getRequest().getContextPath() + "/secure/projectavatar?pid=" + this.getPid() + "&size=large&avatarId=" + this.getProjectObject().getAvatar().getId();
    }

    public String getProjectDescriptionEditHtml() {
        return this.projectDescriptionRenderer.getEditHtml(StringUtils.defaultString((String)this.getDescription()));
    }

    public ProjectDescriptionRenderer getProjectDescriptionRenderer() {
        return this.projectDescriptionRenderer;
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (!this.hasProjectAdminPermission() && !this.hasAdminPermission()) {
            return "securitybreach";
        }
        ProjectService.UpdateProjectValidationResult result = this.getUpdateProjectValidationResult();
        this.projectService.updateProject(result);
        String redirectURL = result.isKeyChanged() ? "/secure/project/IndexProject.jspa?pid=" + this.getProjectObject().getId() : "/plugins/servlet/project-config/" + result.getKey() + "/summary";
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect(redirectURL);
        }
        return this.getRedirect(redirectURL);
    }

    public boolean hasInvalidLead() {
        Project projectObject = this.getProjectObject();
        if (projectObject == null) {
            return false;
        }
        String leadUserName = projectObject.getLeadUserName();
        return this.userManager.getUserObject(leadUserName) == null;
    }

    public Long getDefaultAvatar() {
        return this.avatarManager.getDefaultAvatarId(Avatar.Type.PROJECT);
    }

    public int getMaxNameLength() {
        return this.projectService.getMaximumNameLength();
    }

    public int getMaxKeyLength() {
        return this.projectService.getMaximumKeyLength();
    }

    public boolean isProjectKeyRenameAllowed() {
        return this.darkFeatures.isFeatureEnabled("editproject.key.rename") && this.hasAdminPermission();
    }

    public void setOriginalKey(String originalKey) {
        this.originalKey = originalKey;
    }

    public String getOriginalKey() {
        return this.originalKey;
    }

    public void setKeyEdited(boolean keyEdited) {
        this.keyEdited = keyEdited;
    }

    public boolean isKeyEdited() {
        return this.keyEdited;
    }

    @Override
    public String getKey() {
        if (!this.isKeyEdited()) {
            return this.getOriginalKey();
        }
        return super.getKey();
    }
}

