/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.operation.BulkMigrateOperation;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.bulkedit.BulkMove;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.WorkflowManager;
import java.util.List;
import org.apache.commons.collections.map.ListOrderedMap;

public class BulkMigrate
extends BulkMove {
    private String sameAsBulkEditBean;
    protected final BulkMigrateOperation bulkMigrateOperation;

    public BulkMigrate(SearchService searchService, BulkMoveOperation bulkMoveOperation, FieldManager fieldManager, WorkflowManager workflowManager, ConstantsManager constantsManager, IssueFactory issueFactory, BulkMigrateOperation bulkMigrateOperation, PermissionManager permissionManager) {
        super(searchService, bulkMoveOperation, fieldManager, workflowManager, constantsManager, issueFactory, permissionManager);
        this.bulkMigrateOperation = bulkMigrateOperation;
    }

    @Override
    public String doDetails() {
        BulkEditBean rootBulkEditBean = this.getRootBulkEditBean();
        if (rootBulkEditBean == null) {
            return this.redirectToStart();
        }
        rootBulkEditBean.setOperationName(this.getBulkMigrateOperation().getOperationName());
        rootBulkEditBean.resetMoveData();
        rootBulkEditBean.initMultiBulkBean();
        rootBulkEditBean.clearAvailablePreviousSteps();
        rootBulkEditBean.addAvailablePreviousStep(1);
        rootBulkEditBean.addAvailablePreviousStep(2);
        if (this.isCanDisableMailNotifications()) {
            rootBulkEditBean.setSendBulkNotification(false);
        } else {
            rootBulkEditBean.setSendBulkNotification(true);
        }
        rootBulkEditBean.setCurrentStep(3);
        return "success";
    }

    public String doStart() throws Exception {
        return "success";
    }

    public String doChooseContext() throws Exception {
        BulkEditBean currentRootBulkEditBean = this.getCurrentRootBulkEditBean();
        if (currentRootBulkEditBean == null) {
            return this.redirectToStart();
        }
        MultiBulkMoveBean rootMultiBulkMoveBean = currentRootBulkEditBean.getRelatedMultiBulkMoveBean();
        ListOrderedMap bulkEditBeans = rootMultiBulkMoveBean.getBulkEditBeans();
        for (Object o1 : bulkEditBeans.values()) {
            BulkEditBean bulkEditBean = (BulkEditBean)o1;
            bulkEditBean.resetMoveData();
        }
        this.getBulkMigrateOperation().chooseContext(currentRootBulkEditBean, this.getLoggedInUser(), (I18nHelper)this, (ErrorCollection)this);
        if (this.invalidInput()) {
            return "input";
        }
        rootMultiBulkMoveBean.remapBulkEditBeansByTargetContext();
        this.getBulkMigrateOperation().getBulkMoveOperation().finishChooseContext(rootMultiBulkMoveBean, this.getLoggedInUser());
        boolean needsSubTaskChooseContext = false;
        for (Object o : rootMultiBulkMoveBean.getBulkEditBeans().values()) {
            BulkEditBean targetContextBean = (BulkEditBean)o;
            if (targetContextBean.getSubTaskBulkEditBean() == null) continue;
            needsSubTaskChooseContext = true;
            targetContextBean.initMultiBulkBeanWithSubTasks();
        }
        if (needsSubTaskChooseContext) {
            return this.getRedirect("BulkMigrateChooseSubTaskContext!default.jspa");
        }
        return this.getNextRedirect();
    }

    public String doChooseSubTaskContext() throws Exception {
        BulkEditBean currentRootBulkEditBean;
        BulkEditBean rootBulkEditBean = this.getRootBulkEditBean();
        if (rootBulkEditBean == null) {
            return this.redirectToStart();
        }
        for (Object o1 : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            currentRootBulkEditBean = (BulkEditBean)o1;
            if (currentRootBulkEditBean.getRelatedMultiBulkMoveBean() == null) continue;
            ListOrderedMap subTaskBeans = currentRootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans();
            for (Object o : subTaskBeans.values()) {
                BulkEditBean subTaskBean = (BulkEditBean)o;
                subTaskBean.resetMoveData();
            }
            this.getBulkMigrateOperation().chooseContext(currentRootBulkEditBean, this.getLoggedInUser(), (I18nHelper)this, (ErrorCollection)this);
        }
        if (this.invalidInput()) {
            return "input";
        }
        for (Object o : rootBulkEditBean.getRelatedMultiBulkMoveBean().getBulkEditBeans().values()) {
            currentRootBulkEditBean = (BulkEditBean)o;
            MultiBulkMoveBean multiBulkMoveBean = currentRootBulkEditBean.getRelatedMultiBulkMoveBean();
            if (multiBulkMoveBean == null) continue;
            multiBulkMoveBean.remapBulkEditBeansByTargetContext();
            this.getBulkMigrateOperation().getBulkMoveOperation().finishChooseContext(multiBulkMoveBean, this.getLoggedInUser());
        }
        return this.getNextRedirect();
    }

    public String doChooseStatus() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkMigrateOperation().setStatusFields(this.getCurrentRootBulkEditBean());
        return this.getRedirect("BulkMigrateSetFields!default.jspa");
    }

    public String doSetFields() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkMigrateOperation().validatePopulateFields(this.getCurrentRootBulkEditBean(), (I18nHelper)this, (ErrorCollection)this);
        if (this.invalidInput()) {
            return "error";
        }
        if (this.getBulkEditBean().getRelatedMultiBulkMoveBean() != null) {
            this.setSubTaskPhase(true);
            return this.getNextRedirect();
        }
        if (!this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().isLastBulkEditBean()) {
            this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().progressToNextBulkEditBean();
            return this.getNextRedirect();
        }
        if (this.isSubTaskPhase()) {
            this.setSubTaskPhase(false);
        }
        if (!this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().isLastBulkEditBean()) {
            this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().progressToNextBulkEditBean();
            return this.getNextRedirect();
        }
        this.progressToLastStep();
        return "confirm";
    }

    @Override
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
            this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            return "error";
        }
        if (!this.getBulkMigrateOperation().canPerform(this.getRootBulkEditBean(), this.getLoggedInUser())) {
            this.addErrorMessage(this.getText("bulk.move.cannotperform"));
            return "error";
        }
        String movedIssueKey = this.findFirstMovedIssueKey();
        if (movedIssueKey != null) {
            this.addErrorMessage(this.getText("bulk.move.error.issue.already.moved", movedIssueKey));
            return "error";
        }
        try {
            this.getBulkMigrateOperation().perform(this.getRootBulkEditBean(), this.getLoggedInUser());
        }
        catch (Exception e) {
            this.log.error((Object)"Error while performing Bulk Edit operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.edit.perform.error"));
            return "error";
        }
        return this.finishWizard();
    }

    private String findFirstMovedIssueKey() {
        List selectedIssues = this.getBulkEditBean().getSelectedIssues();
        for (Issue selectedIssue : selectedIssues) {
            MutableIssue latestIssue = this.getIssueManager().getIssueObject(selectedIssue.getId());
            if (latestIssue.getKey().equals(selectedIssue.getKey())) continue;
            return selectedIssue.getKey();
        }
        return null;
    }

    @Override
    public BulkEditBean getBulkEditBean() {
        if (this.getCurrentRootBulkEditBean() != null) {
            return this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().getCurrentBulkEditBean();
        }
        return null;
    }

    public MultiBulkMoveBean getMultiBulkMoveBean() {
        return this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean();
    }

    public IssueContext getCurrentIssueContext() {
        return this.getCurrentRootBulkEditBean().getRelatedMultiBulkMoveBean().getCurrentIssueContext();
    }

    public BulkEditBean getCurrentRootBulkEditBean() {
        BulkEditBean currentBulkEditBean = null;
        if (!this.isSubTaskPhase()) {
            currentBulkEditBean = this.getRootBulkEditBean();
        } else if (this.getRootBulkEditBean() != null) {
            currentBulkEditBean = this.getRootBulkEditBean().getRelatedMultiBulkMoveBean().getCurrentBulkEditBean();
        }
        return currentBulkEditBean;
    }

    @Override
    public String getOperationDetailsActionName() {
        return this.getBulkMigrateOperation().getOperationName() + "Details.jspa";
    }

    public String getprojectFieldName(BulkEditBean bulkEditBean) {
        return bulkEditBean.getKey() + "pid";
    }

    public String getSameAsBulkEditBean() {
        return this.sameAsBulkEditBean;
    }

    public void setSameAsBulkEditBean(String sameAsBulkEditBean) {
        this.sameAsBulkEditBean = sameAsBulkEditBean;
    }

    protected BulkMigrateOperation getBulkMigrateOperation() {
        return this.bulkMigrateOperation;
    }

    public String getRedirect(String defaultUrl) {
        return super.getRedirect(defaultUrl + "?subTaskPhase=" + this.isSubTaskPhase());
    }

    private String getNextRedirect() {
        if (!this.getBulkMigrateOperation().isStatusValid(this.getCurrentRootBulkEditBean())) {
            return this.getRedirect("BulkMigrateChooseStatus!default.jspa");
        }
        return this.getRedirect("BulkMigrateSetFields!default.jspa");
    }
}

