/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationAction;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class BulkEdit1
extends AbstractBulkOperationAction {
    private String reset;
    private long tempMax = -1L;
    private static final PagerFilter ALL_ISSUES_PAGER = PagerFilter.getUnlimitedFilter();
    private final SearchProvider searchProvider;
    private final IssueManager issueManager;
    private ApplicationProperties applicationProperties;

    public BulkEdit1(SearchService searchService, SearchProvider searchProvider, IssueManager issueManager, ApplicationProperties applicationProperties) {
        super(searchService);
        this.searchProvider = searchProvider;
        this.issueManager = issueManager;
        this.applicationProperties = applicationProperties;
    }

    public String doDefault() throws Exception {
        if (this.getSearchRequest() == null) {
            return this.getRedirect("IssueNavigator.jspa");
        }
        if (this.isNewBulkEdit()) {
            this.initialiseBulkEditBean();
        }
        return super.doDefault();
    }

    private void initialiseBulkEditBean() throws SearchException {
        PagerFilter pager;
        BulkEditBeanImpl bulkEditBean = new BulkEditBeanImpl(this.issueManager);
        bulkEditBean.setIssuesInUse(bulkEditBean.getIssuesFromSearchRequest());
        if (this.getTempMax() > -1L) {
            int max = (int)Math.min(Integer.MAX_VALUE, this.getTempMax());
            pager = new PagerFilter(max);
            bulkEditBean.setMaxIssues(max);
        } else {
            pager = (PagerFilter)this.getSessionPagerFilterManager().getCurrentObject();
            if (pager == null) {
                pager = ALL_ISSUES_PAGER;
            }
        }
        List issues = this.searchProvider.search(this.getSearchRequest() != null ? this.getSearchRequest().getQuery() : null, this.getLoggedInUser(), pager).getIssues();
        bulkEditBean.setIssuesFromSearchRequest(issues);
        BulkEditBeanSessionHelper.storeToSession(bulkEditBean);
    }

    protected void doValidation() {
        if (this.getSearchRequest() != null) {
            try {
                this.initialiseBulkEditBean();
            }
            catch (SearchException e) {
                this.log.error((Object)"Error occurred while initialising BulkEditBean.", (Throwable)e);
                this.addErrorMessage(this.getText("bulk.bean.initialise.error"));
            }
            this.getBulkEditBean().setParams(ActionContext.getParameters());
            List selectedIssues = this.getBulkEditBean().getSelectedIssues();
            if (selectedIssues.isEmpty()) {
                this.addErrorMessage(this.getText("bulk.edit.you.must.select.at.least.one.issue"));
            } else {
                String maxIssuesString = this.getApplicationProperties().getDefaultBackedString("jira.bulk.edit.limit.issue.count");
                if (StringUtils.isNotEmpty((String)maxIssuesString)) {
                    try {
                        int maxIssues = Integer.parseInt(maxIssuesString);
                        if (maxIssues >= 0 && selectedIssues.size() > maxIssues) {
                            this.addErrorMessage(this.getText("bulk.edit.limit.issue.count.error", Integer.toString(maxIssues)));
                        }
                    }
                    catch (NumberFormatException e) {
                        this.log.error((Object)("Error parsing property 'jira.bulk.edit.limit.issue.count' = '" + maxIssuesString + "' as it is not a number. Ignoring property."), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    public List getColumns() throws Exception {
        List columns = super.getColumns();
        columns.add(0, this.getCheckboxColumn());
        return columns;
    }

    private SimpleColumnLayoutItem getCheckboxColumn() {
        return new SimpleColumnLayoutItem(){

            @Override
            public String getHtml(Map displayParams, Issue issue) {
                String name = BulkEdit1.this.getBulkEditBean().getCheckboxName(issue);
                String checked = BulkEdit1.this.getBulkEditBean().isChecked(issue) ? "checked" : "";
                return String.format("<input type=\"checkbox\" name=\"%s\" %s />", name, checked);
            }

            @Override
            public String getHeaderHtml() {
                return "<input type='checkbox' id='bulkedit-select-all' name='all' value='on'>";
            }
        };
    }

    protected String doExecute() throws Exception {
        if (this.getSearchRequest() == null) {
            return this.redirectToSessionTimeout();
        }
        this.getBulkEditBean().setCurrentStep(2);
        return this.getRedirect("BulkChooseOperation!default.jspa");
    }

    public String getCheckboxName(GenericValue issue) {
        return "bulkedit_" + issue.getLong("id");
    }

    public String getReset() {
        return this.reset;
    }

    public void setReset(String reset) {
        this.reset = reset;
    }

    private boolean isNewBulkEdit() {
        return "true".equals(this.getReset());
    }

    public void setCurrentStep(int step) {
        this.getBulkEditBean().setCurrentStep(step);
    }

    public long getTempMax() {
        return this.tempMax;
    }

    public void setTempMax(long tempMax) {
        this.tempMax = tempMax;
    }

    public boolean isBulkLimited() {
        String maxBulkEdit = this.applicationProperties.getDefaultBackedString("jira.bulk.edit.limit.issue.count");
        if (maxBulkEdit != null) {
            try {
                int configuredMax = Integer.parseInt(maxBulkEdit);
                return this.tempMax == (long)configuredMax;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private String redirectToSessionTimeout() {
        ActionContext.getSession().put("jira.session.timeout.message", this.getText("bulk.edit.session.timeout.message"));
        return this.getRedirect("SessionTimeoutMessage.jspa");
    }
}

