/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.bulkedit.operation.BulkOperation;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.bulkedit.AbstractBulkOperationDetailsAction;
import com.atlassian.jira.web.bean.BulkEditBean;

public abstract class AbstractBulkWatchOperationAction
extends AbstractBulkOperationDetailsAction {
    private final BulkOperation genericBulkWatchOperation;
    private final PermissionManager permissionManager;

    protected abstract String getOperationNameKey();

    protected abstract String getOperationName();

    protected abstract String getCannotPerformErrorI18nKey();

    protected abstract String getSessionTimeoutMessageI18nKey();

    protected abstract String getPerformErrorI18nKey();

    protected abstract String getWatchingDisabledErrorI18nKey();

    public AbstractBulkWatchOperationAction(SearchService searchService, BulkOperationManager bulkOperationManager, PermissionManager permissionManager) {
        super(searchService);
        this.permissionManager = permissionManager;
        this.genericBulkWatchOperation = bulkOperationManager.getOperation(this.getOperationNameKey());
    }

    public boolean isHasAvailableActions() throws Exception {
        return this.getGenericBulkWatchOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser());
    }

    public String getOperationDetailsActionName() {
        return this.getGenericBulkWatchOperation().getOperationName() + "Details.jspa";
    }

    public void doPerformValidation() {
        try {
            if (!this.permissionManager.hasPermission(33, this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("bulk.change.no.permission", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
            if (this.getGenericBulkWatchOperation() == null) {
                this.addErrorMessage(this.getText(this.getWatchingDisabledErrorI18nKey()));
                return;
            }
            if (!this.getGenericBulkWatchOperation().canPerform(this.getBulkEditBean(), this.getLoggedInUser())) {
                this.addErrorMessage(this.getText(this.getCannotPerformErrorI18nKey(), String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occured while testing operation.", (Throwable)e);
            this.addErrorMessage(this.getText("bulk.canperform.error"));
        }
    }

    @Override
    public String doDetails() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart(this.getSessionTimeoutMessageI18nKey());
        }
        return this.getRedirect(this.getOperationName() + "DetailsValidation.jspa");
    }

    @Override
    public String doDetailsValidation() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart(this.getSessionTimeoutMessageI18nKey());
        }
        BulkEditBean bulkEditBean = this.getBulkEditBean();
        bulkEditBean.clearAvailablePreviousSteps();
        bulkEditBean.addAvailablePreviousStep(1);
        bulkEditBean.addAvailablePreviousStep(2);
        bulkEditBean.addAvailablePreviousStep(3);
        bulkEditBean.setCurrentStep(4);
        return "input";
    }

    @Override
    @RequiresXsrfCheck
    public String doPerform() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart(this.getSessionTimeoutMessageI18nKey());
        }
        this.doPerformValidation();
        if (this.invalidInput()) {
            return "error";
        }
        try {
            this.getGenericBulkWatchOperation().perform(this.getBulkEditBean(), this.getLoggedInUser());
        }
        catch (Exception e) {
            this.log.error((Object)"Error while performing bulk watch or unwatch operation", (Throwable)e);
            this.addErrorMessage(this.getText(this.getPerformErrorI18nKey()));
            return "error";
        }
        return this.finishWizard();
    }

    public BulkOperation getGenericBulkWatchOperation() {
        return this.genericBulkWatchOperation;
    }
}

