/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.issue.navigator.ToolOptionGroup;
import com.atlassian.jira.web.action.issue.navigator.ToolOptionItem;
import com.atlassian.query.Query;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class IssueNavigatorToolsHelper {
    private static final Logger log = Logger.getLogger(IssueNavigatorToolsHelper.class);
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final ColumnLayoutManager columnLayoutManager;
    private SearchRequestInfo searchRequestInfo;
    private SearchResultInfo searchResultInfo;

    public IssueNavigatorToolsHelper(JiraAuthenticationContext authContext, PermissionManager permissionManager, ApplicationProperties applicationProperties, ColumnLayoutManager columnLayoutManager, SearchRequestInfo searchRequestInfo, SearchResultInfo searchResultInfo) {
        this.authContext = authContext;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.columnLayoutManager = columnLayoutManager;
        this.searchRequestInfo = searchRequestInfo;
        this.searchResultInfo = searchResultInfo;
    }

    public List<ToolOptionGroup> getToolOptions() throws ColumnLayoutStorageException {
        ToolOptionItem item;
        String url;
        String label;
        ToolOptionGroup group;
        ArrayList<ToolOptionGroup> options = new ArrayList<ToolOptionGroup>();
        if (this.isHasBulkChangePermission()) {
            group = new ToolOptionGroup(this.getText("navigator.results.currentview.bulkchange"));
            options.add(group);
            if (this.isBulkEditLimited()) {
                label = this.getText("navigator.results.currentview.bulkchange.limitedissues", this.getBulkEditMax());
                url = "/secure/views/bulkedit/BulkEdit1!default.jspa?reset=true&tempMax=" + this.getBulkEditMax();
                String title = this.getText("bulk.edit.limited", this.getBulkEditMax());
                ToolOptionItem item2 = new ToolOptionItem("bulkedit_max", label, url, title);
                group.addItem(item2);
            } else {
                label = this.getText("navigator.results.currentview.bulkchange.allissues", this.searchResultInfo.total);
                url = "/secure/views/bulkedit/BulkEdit1!default.jspa?reset=true&tempMax=" + this.searchResultInfo.total;
                item = new ToolOptionItem("bulkedit_all", label, url, "");
                group.addItem(item);
            }
            if (this.searchResultInfo.pages > 1) {
                label = this.getText("navigator.results.currentview.bulkchange.currentpage");
                url = "/secure/views/bulkedit/BulkEdit1!default.jspa?reset=true";
                item = new ToolOptionItem("bulkedit_curr_pg", label, url, "");
                group.addItem(item);
            }
        }
        if (this.searchRequestInfo.query != null && this.searchRequestInfo.query.getOrderByClause() != null && !this.searchRequestInfo.query.getOrderByClause().getSearchSorts().isEmpty()) {
            group = new ToolOptionGroup();
            options.add(group);
            label = this.getText("navigator.results.clear.sorts");
            url = "/secure/IssueNavigator!clearSorts.jspa";
            item = new ToolOptionItem("", label, url, "");
            group.addItem(item);
        }
        if (this.getLoggedInApplicationUser() != null && this.permissionManager.hasPermission(1, this.authContext.getLoggedInUser()) && !this.shouldSkipColumns()) {
            group = new ToolOptionGroup();
            options.add(group);
            if (!this.isShowOverrideColumnLayout()) {
                label = this.getText("navigator.results.configurenavigator");
                url = "/secure/ViewUserIssueColumns!default.jspa";
                item = new ToolOptionItem("configure-cols", label, url, "");
                group.addItem(item);
            } else {
                label = this.getText("navigator.results.useyourcolumns");
                url = "/secure/IssueNavigator!columnOverride.jspa";
                item = new ToolOptionItem("use-cols", label, url, "");
                group.addItem(item);
            }
        }
        if (this.isHasSearchRequestColumnLayout() && !this.isShowOverrideColumnLayout()) {
            group = new ToolOptionGroup();
            options.add(group);
            label = this.getText("navigator.results.usefilterscolumns");
            url = "/secure/IssueNavigator!columnOverride.jspa";
            item = new ToolOptionItem("use-filter-cols", label, url, "");
            group.addItem(item);
        }
        if (this.searchRequestInfo.filterId != null && this.isOwnerOfSearchRequest()) {
            group = new ToolOptionGroup();
            options.add(group);
            if (this.isHasSearchRequestColumnLayout()) {
                if (this.isShowOverrideColumnLayout()) {
                    label = this.getText("navigator.results.filter.columns.edit");
                    url = "/secure/ViewSearchRequestIssueColumns!default.jspa?filterId=" + this.searchRequestInfo.filterId;
                    item = new ToolOptionItem("editFilterColumnsLink", label, url, "");
                    group.addItem(item);
                }
            } else {
                label = this.getText("navigator.results.filter.columns.add");
                url = "/secure/ViewSearchRequestIssueColumns!default.jspa?filterId=" + this.searchRequestInfo.filterId;
                item = new ToolOptionItem("addFilterColumnsLink", label, url, "");
                group.addItem(item);
            }
        }
        return options;
    }

    public boolean isHasBulkChangePermission() {
        if (this.searchRequestInfo == null) {
            return false;
        }
        PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
        try {
            return permissionManager.hasPermission(33, this.authContext.getLoggedInUser());
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public boolean isBulkEditLimited() {
        return this.getBulkEditMax() != this.searchResultInfo.total;
    }

    public int getBulkEditMax() {
        return this.getBulkEditMax(this.searchResultInfo.total, this.applicationProperties.getDefaultBackedString("jira.bulk.edit.limit.issue.count"));
    }

    int getBulkEditMax(int searchTotal, String bulkEditSetting) {
        int max = searchTotal;
        if (bulkEditSetting != null) {
            try {
                int configuredMax = Integer.parseInt(bulkEditSetting);
                if (configuredMax > 0) {
                    max = Math.min(searchTotal, configuredMax);
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Ignoring JIRA application property jira.bulk.edit.limit.issue.count because it cannot be parsed as a number: " + bulkEditSetting));
            }
        }
        return max;
    }

    public boolean isHasSearchRequestColumnLayout() throws ColumnLayoutStorageException {
        if (this.searchRequestInfo != null) {
            return this.columnLayoutManager.hasColumnLayout(this.searchRequestInfo.filterId);
        }
        return false;
    }

    public boolean isOwnerOfSearchRequest() {
        if (this.searchRequestInfo != null && this.getLoggedInApplicationUser() != null) {
            return this.getLoggedInApplicationUser().getKey().equals(this.searchRequestInfo.ownerUserKey);
        }
        return false;
    }

    public boolean isShowOverrideColumnLayout() throws ColumnLayoutStorageException {
        if (this.searchRequestInfo != null) {
            return this.isHasSearchRequestColumnLayout() && this.searchRequestInfo.useColumns;
        }
        throw new IllegalStateException("Search Request does not exist.");
    }

    private boolean shouldSkipColumns() throws ColumnLayoutStorageException {
        if (this.searchRequestInfo != null) {
            return this.searchRequestInfo.skipColumns;
        }
        throw new IllegalStateException("Search Request does not exist.");
    }

    private ApplicationUser getLoggedInApplicationUser() {
        return this.authContext.getUser();
    }

    private String getText(String key) {
        return this.authContext.getI18nHelper().getText(key);
    }

    private String getText(String key, Object values) {
        return this.authContext.getI18nHelper().getText(key, values);
    }

    public static class SearchResultInfo {
        public final int total;
        public final int pages;

        public SearchResultInfo(int total, int pages) {
            this.total = total;
            this.pages = pages;
        }
    }

    public static class SearchRequestInfo {
        public final Long filterId;
        public final Query query;
        public final boolean useColumns;
        public final boolean skipColumns;
        public final String ownerUserKey;

        public SearchRequestInfo(Long filterId, Query query, boolean useColumns, boolean skipColumns, String ownerUserName) {
            this.filterId = filterId;
            this.query = query;
            this.useColumns = useColumns;
            this.skipColumns = skipColumns;
            this.ownerUserKey = ownerUserName;
        }

        public SearchRequestInfo(Long filterId, Query query, boolean useColumns, String ownerUserName) {
            this.filterId = filterId;
            this.query = query;
            this.useColumns = useColumns;
            this.skipColumns = false;
            this.ownerUserKey = ownerUserName;
        }
    }
}

