/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.action.issue.IssueSummaryAware;
import com.atlassian.jira.web.action.issue.SelectedIssue;
import com.atlassian.jira.web.component.issuesummary.IssueSummaryLayoutBean;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public abstract class AbstractIssueSelectAction
extends IssueActionSupport
implements IssueSummaryAware {
    public static final String ISSUE_PERMISSION_ERROR = "issue-permission-error";
    public static final String PREPOPULATED_ISSUE_OBJECT = AbstractIssueSelectAction.class.getCanonicalName() + "prepopulated.issue";
    private final SubTaskManager subTaskManager;
    protected Long id;
    private final SelectedIssue issue = new SelectedIssue(new IssueGetter());
    private GenericValue project;
    private String key;
    private String viewIssueKey;
    private Issue parentIssueObject = null;

    protected AbstractIssueSelectAction() {
        this((SubTaskManager)ComponentAccessor.getComponent(SubTaskManager.class));
    }

    protected AbstractIssueSelectAction(SubTaskManager subTaskManager) {
        this.subTaskManager = subTaskManager;
    }

    public boolean isIssueExists() {
        return this.issue.exists();
    }

    public boolean isIssueValid() {
        if (!this.issue.exists()) {
            this.addErrorMessage(this.getText("issue.wasdeleted"));
            return false;
        }
        if (!this.userCanBrowse((Issue)this.issue.object())) {
            this.addErrorMessage(this.getText("admin.errors.issues.no.permission.to.see"));
            return false;
        }
        return true;
    }

    @Nonnull
    private SelectedIssue.GetterResult getIssueResultFromRequestOrDatabase() {
        if (this.id == null && this.key == null) {
            return new SelectedIssue.GetterResult(null);
        }
        MutableIssue issueFromRequest = this.readPrepopulatedIssueFromRequest();
        if (issueFromRequest != null) {
            return new SelectedIssue.GetterResult(issueFromRequest);
        }
        MutableIssue issueFromManager = null;
        if (this.id != null) {
            issueFromManager = this.getIssueManager().getIssueObject(this.id);
        }
        if (issueFromManager == null && this.key != null) {
            issueFromManager = this.getIssueManager().getIssueObject(this.key);
        }
        return new SelectedIssue.GetterResult(issueFromManager);
    }

    private MutableIssue readPrepopulatedIssueFromRequest() {
        MutableIssue issue = (MutableIssue)this.request.getAttribute(PREPOPULATED_ISSUE_OBJECT);
        if (issue != null) {
            this.request.setAttribute(PREPOPULATED_ISSUE_OBJECT, null);
        }
        return issue;
    }

    @Nonnull
    public GenericValue getIssue() throws IssueNotFoundException, IssuePermissionException {
        this.assertIssueIsValid();
        return this.issue.genericValue();
    }

    @Nonnull
    public MutableIssue getIssueObject() throws IssueNotFoundException, IssuePermissionException {
        this.assertIssueIsValid();
        return this.issue.object();
    }

    protected MutableIssue refreshIssueObject() {
        GenericValue issueGV = this.getIssue();
        this.setIssueObject(this.issueFactory().getIssue(issueGV));
        return this.issue.object();
    }

    protected MutableIssue getIssueObjectWithoutDatabaseRead() {
        return this.issue.object();
    }

    public Long getId() {
        if (this.id == null && this.issue.exists()) {
            this.id = this.issue.object().getId();
        }
        return this.id;
    }

    public String getKey() {
        if (this.key == null && this.issue.exists()) {
            this.key = this.issue.object().getKey();
        }
        return this.key;
    }

    protected MutableIssue setIssueObject(@Nullable MutableIssue issueObject) {
        if (issueObject != null) {
            this.id = issueObject.getId();
            this.key = issueObject.getKey();
        }
        this.issue.setObject(issueObject);
        return issueObject;
    }

    private IssueFactory issueFactory() {
        return (IssueFactory)ComponentAccessor.getComponent(IssueFactory.class);
    }

    public void setId(Long id) {
        this.id = id;
        this.key = null;
    }

    public void setKey(String key) {
        this.key = key.toUpperCase();
        this.id = null;
    }

    public GenericValue getProject() {
        if (this.project == null && this.getIssue() != null) {
            this.project = this.getProjectManager().getProject(this.getIssue());
        }
        return this.project;
    }

    private Project getProjectObject() {
        if (this.getIssueObject() == null) {
            return null;
        }
        return this.getIssueObject().getProjectObject();
    }

    public GenericValue getSecurityLevel(Long id) throws Exception {
        if (this.getIssue() != null) {
            IssueSecurityLevelManager secur = ComponentAccessor.getIssueSecurityLevelManager();
            return secur.getIssueSecurity(id);
        }
        return null;
    }

    public String getViewIssueKey() {
        return this.viewIssueKey;
    }

    public void setViewIssueKey(String viewIssueKey) {
        this.viewIssueKey = viewIssueKey;
    }

    protected String redirectToView() throws Exception {
        return this.getRedirect(this.getViewUrl());
    }

    public String getViewUrl() {
        return "/browse/" + this.getRedirectKey();
    }

    public String getIssuePath() {
        try {
            return "/browse/" + this.getRedirectKey();
        }
        catch (IssueNotFoundException e) {
            this.log.trace((Object)e);
            return "";
        }
    }

    private String getRedirectKey() {
        String key = TextUtils.stringSet((String)this.getViewIssueKey()) ? this.getViewIssueKey() : (this.issue.exists() ? this.issue.object().getKey() : "");
        return key;
    }

    public boolean isEditable() {
        return this.isEditable((Issue)this.getIssueObject());
    }

    public boolean isEditable(Issue issue) {
        if (issue == null) {
            throw new IssueNotFoundException("Issue unexpectedly null");
        }
        boolean hasPermission = this.isHasEditIssuePermission(issue);
        return hasPermission && this.isWorkflowAllowsEdit(issue);
    }

    public boolean isHasEditIssuePermission(Issue issue) {
        if (issue == null) {
            throw new IssueNotFoundException("Issue unexpectedly null");
        }
        return this.hasIssuePermission(12, issue);
    }

    public boolean isWorkflowAllowsEdit(Issue issue) {
        return this.getIssueManager().isEditable(issue);
    }

    public boolean cameFromIssue() {
        String header;
        HttpServletRequest request = ActionContext.getRequest();
        if (request != null && StringUtils.isNotBlank((String)(header = request.getHeader("referer")))) {
            return header.contains("browse/" + this.getIssueObject().getKey());
        }
        return false;
    }

    public boolean cameFromParent() {
        String header;
        Issue parent = this.getIssueObject().getParentObject();
        if (parent == null) {
            return false;
        }
        HttpServletRequest request = ActionContext.getRequest();
        if (request != null && StringUtils.isNotBlank((String)(header = request.getHeader("referer")))) {
            return header.contains("browse/" + parent.getKey());
        }
        return false;
    }

    @Override
    public Issue getSummaryIssue() {
        return this.getIssueObject();
    }

    @Override
    public IssueSummaryLayoutBean getLayoutBean() {
        return new IssueSummaryLayoutBean(false);
    }

    protected SubTaskManager getSubTaskManager() {
        return this.subTaskManager;
    }

    public boolean isSubTask() {
        GenericValue issue = this.getIssue();
        if (issue == null) {
            this.addErrorMessage(this.getText("admin.errors.issues.current.issue.null"));
            return false;
        }
        return this.getSubTaskManager().isSubTask(issue);
    }

    public boolean isSubTaskCreatable() {
        Collection subTaskOptions = ComponentAccessor.getFieldManager().getIssueTypeField().getOptionsForIssue((Issue)this.getIssueObject(), true);
        return this.getSubTaskManager().isSubTasksEnabled() && !this.isSubTask() && this.isEditable() && this.hasProjectPermission(11, this.getProjectObject()) && subTaskOptions != null && !subTaskOptions.isEmpty();
    }

    public Issue getParentIssueObject() {
        if (this.isSubTask() && this.parentIssueObject == null) {
            GenericValue issue = this.getIssue();
            if (issue == null) {
                this.addErrorMessage(this.getText("admin.errors.current.issue.null"));
                return null;
            }
            this.parentIssueObject = this.getIssueManager().getIssueObject(this.getSubTaskManager().getParentIssueId(issue));
        }
        return this.parentIssueObject;
    }

    public void addErrorMessage(String message) {
        if (this.errorMessages == null || !this.errorMessages.contains(message)) {
            super.addErrorMessage(message);
        }
    }

    protected void assertIssueIsValid() throws IssueNotFoundException, IssuePermissionException {
        if (!this.isIssueExists()) {
            this.addErrorMessage(this.getText("issue.wasdeleted"));
            throw new IssueNotFoundException("Issue with id '" + this.id + "' or key '" + this.key + "' could not be found in the system");
        }
        if (!this.isIssueValid()) {
            MutableIssue issueObject = this.issue.object();
            String issueStr = issueObject.getKey() != null ? issueObject.getKey() : issueObject.toString();
            throw new IssuePermissionException("User '" + this.getLoggedInUser() + "' does not have permission to see issue '" + issueStr + "'");
        }
    }

    private boolean userCanBrowse(Issue issue) {
        return this.getPermissionManager().hasPermission(10, issue, this.getLoggedInUser());
    }

    private class IssueGetter
    implements SelectedIssue.Getter {
        private IssueGetter() {
        }

        @Override
        @Nonnull
        public SelectedIssue.GetterResult get() {
            SelectedIssue.GetterResult issue = AbstractIssueSelectAction.this.getIssueResultFromRequestOrDatabase();
            if (issue.object != null && AbstractIssueSelectAction.this.userCanBrowse((Issue)issue.object)) {
                AbstractIssueSelectAction.this.addIssueToHistory((Issue)issue.object);
            }
            return issue;
        }
    }
}

