/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.plugin.workflow.WorkflowFunctionModuleDescriptor;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransition;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@WebSudoRequired
public class AddWorkflowTransition
extends AbstractWorkflowTransition {
    private final PluginAccessor pluginAccessor;
    private final FieldScreenManager fieldScreenManager;
    private Collection fieldScreens;

    public AddWorkflowTransition(JiraWorkflow workflow, StepDescriptor step, PluginAccessor pluginAccessor, FieldScreenManager fieldScreenManager, WorkflowService workflowService) {
        super(workflow, step, workflowService);
        this.pluginAccessor = pluginAccessor;
        this.fieldScreenManager = fieldScreenManager;
    }

    public String doDefault() throws Exception {
        if (this.workflowService.isStepOnDraftWithNoTransitionsOnParentWorkflow(this.getJiraServiceContext(), this.getWorkflow(), this.getStep().getId())) {
            this.addErrorMessage(this.getText("admin.workflowtransitions.error.add.transition.draft.step.without.transition", this.getStep().getName()));
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.getTransitionName())) {
            this.addError("transitionName", this.getText("admin.common.errors.validname"));
        } else {
            this.checkDuplicateTransitionName(this.getStep().getActions(), this.getTransitionName());
            if (!this.invalidInput()) {
                this.checkDuplicateTransitionName(this.getWorkflow().getDescriptor().getGlobalActions(), this.getTransitionName());
            }
        }
        if (TextUtils.stringSet((String)this.getView()) && this.getFieldScreen() == null) {
            this.addError("view", this.getText("admin.errors.workflows.invalid.screen"));
        }
        if (this.workflowService.isStepOnDraftWithNoTransitionsOnParentWorkflow(this.getJiraServiceContext(), this.getWorkflow(), this.getStep().getId())) {
            this.addErrorMessage(this.getText("admin.workflowtransitions.error.add.transition.draft.step.without.transition", this.getStep().getName()));
        }
        super.doValidation();
    }

    private FieldScreen getFieldScreen() {
        return this.fieldScreenManager.getFieldScreen(new Long(this.getView()));
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ActionDescriptor action = DescriptorFactory.getFactory().createActionDescriptor();
        action.setId(this.getWorkflow().getNextActionId());
        action.setName(this.getTransitionName());
        action.getMetaAttributes().put("jira.description", this.getDescription());
        if (TextUtils.stringSet((String)this.getView())) {
            action.setView("fieldscreen");
            action.getMetaAttributes().put("jira.fieldscreen.id", this.getFieldScreen().getId().toString());
        } else {
            action.setView(null);
        }
        ResultDescriptor result = DescriptorFactory.getFactory().createResultDescriptor();
        action.setUnconditionalResult(result);
        result.setStep(this.getDestinationStep());
        result.setOldStatus("Not Done");
        result.setStatus("Done");
        this.initialiseTransition(action);
        action.setParent((AbstractDescriptor)this.getStep());
        this.getStep().getActions().add(action);
        this.workflowService.updateWorkflow(this.getJiraServiceContext(), this.getWorkflow());
        return this.getRedirect(this.getCancelUrl());
    }

    public String getCancelUrl() {
        if ("viewWorkflowStep".equals(this.getOriginatingUrl())) {
            return "ViewWorkflowStep.jspa" + this.getBasicWorkflowParameters() + "&workflowStep=" + this.getStep().getId();
        }
        return "ViewWorkflowSteps.jspa" + this.getBasicWorkflowParameters();
    }

    public Collection getFieldScreens() {
        if (this.fieldScreens == null) {
            this.fieldScreens = this.fieldScreenManager.getFieldScreens();
        }
        return this.fieldScreens;
    }

    private void initialiseTransition(ActionDescriptor actionDescriptor) throws PluginParseException {
        ResultDescriptor unconditionalResult = actionDescriptor.getUnconditionalResult();
        List postFunctions = unconditionalResult.getPostFunctions();
        TreeMap<Integer, FunctionDescriptor> functionsToAdd = new TreeMap<Integer, FunctionDescriptor>();
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByType("workflow-function");
        for (Object e : moduleDescriptors) {
            WorkflowFunctionModuleDescriptor functionModuleDescriptor = (WorkflowFunctionModuleDescriptor)e;
            if (!functionModuleDescriptor.isDefault()) continue;
            FunctionDescriptor functionDescriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
            functionDescriptor.setType("class");
            WorkflowPluginFunctionFactory functionFactory = (WorkflowPluginFunctionFactory)functionModuleDescriptor.getModule();
            functionDescriptor.getArgs().put("class.name", functionModuleDescriptor.getImplementationClass().getName());
            functionDescriptor.getArgs().put("full.module.key", AddWorkflowTransition.getFullModuleKey(functionModuleDescriptor.getPluginKey(), functionModuleDescriptor.getKey()));
            functionDescriptor.getArgs().putAll(functionFactory.getDescriptorParams(Collections.EMPTY_MAP));
            if (functionModuleDescriptor.getWeight() != null) {
                functionsToAdd.put(functionModuleDescriptor.getWeight(), functionDescriptor);
                continue;
            }
            functionsToAdd.put(new Integer(Integer.MAX_VALUE), functionDescriptor);
        }
        for (Object object : functionsToAdd.entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            postFunctions.add(entry.getValue());
        }
    }
}

