/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.admin.user.ViewUserProjectRoles;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

@WebSudoRequired
public class EditUserProjectRoles
extends ViewUserProjectRoles {
    public EditUserProjectRoles(ProjectManager projectManager, ProjectRoleService projectRoleService, ProjectFactory projectFactory, CrowdService crowdService) {
        super(projectManager, projectRoleService, projectFactory, crowdService);
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        Map parameters = ActionContext.getParameters();
        Set projectIds = this.getShownProjectIds();
        Collection<Project> projectsToUpdate = this.getProjectsFromIds(projectIds);
        for (Project project : projectsToUpdate) {
            for (ProjectRole projectRole : this.getAllProjectRoles()) {
                this.updateRoleActorsForProjectRole(project, projectRole, parameters);
            }
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return this.forceRedirect("ViewUserProjectRoles.jspa?name=" + JiraUrlCodec.encode((String)this.name));
    }

    public String doRefresh() {
        String projectIdsToAddValue;
        String[] projectIdsToAdd;
        List<String> addIds;
        Set projectIds = this.getShownProjectIds();
        String[] projectsToAdd = (String[])ActionContext.getParameters().get("projects_to_add");
        if (projectsToAdd != null && (addIds = Arrays.asList(projectIdsToAdd = (projectIdsToAddValue = projectsToAdd[0]).split(","))) != null) {
            projectIds.addAll(addIds);
        }
        this.currentVisibleProjects = this.getProjectsFromIds(projectIds);
        return "success";
    }

    public boolean isAllProjectsInCategoryVisible(GenericValue projectCategory) {
        ArrayList projects = new ArrayList(this.getAllProjectsForCategory(projectCategory));
        Collection<Project> visibleProjects = this.getCurrentVisibleProjects();
        projects.removeAll(visibleProjects);
        return projects.isEmpty();
    }

    public Collection<Project> getAllProjectsWithoutCategory() {
        return this.projectFactory.getProjects(this.projectManager.getProjectsWithNoCategory());
    }

    private Set getShownProjectIds() {
        List<Object> shownIds;
        HashSet projectIds = new HashSet();
        String[] shownProjectIds = (String[])ActionContext.getParameters().get("project_shown");
        List<Object> list = shownIds = shownProjectIds == null ? new ArrayList() : Arrays.asList(shownProjectIds);
        if (shownIds != null) {
            projectIds.addAll(shownIds);
        }
        return projectIds;
    }

    private Collection<Project> getProjectsFromIds(Set shownProjects) {
        List projectObjects;
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (Object shownProject : shownProjects) {
            String projectIdString = (String)shownProject;
            projectIds.add(new Long(projectIdString));
        }
        ArrayList projects = Lists.newArrayList();
        List projectGVs = this.projectManager.convertToProjects(projectIds);
        if (projectGVs != null && (projectObjects = this.projectFactory.getProjects((Collection)projectGVs)) != null) {
            projects.addAll(projectObjects);
        }
        return projects;
    }

    private void updateRoleActorsForProjectRole(Project project, ProjectRole projectRole, Map parameters) {
        String key = project.getId() + "_" + projectRole.getId();
        String[] origParam = (String[])parameters.get(key + "_orig");
        boolean origValue = Boolean.valueOf(origParam[0]);
        String[] newValue = (String[])parameters.get(key);
        if (newValue == null && origValue) {
            this.projectRoleService.removeActorsFromProjectRole((Collection)EasyList.build((Object)this.getUserKey()), projectRole, project, "atlassian-user-role-actor", (ErrorCollection)this);
        } else if (newValue != null && !origValue) {
            this.projectRoleService.addActorsToProjectRole((Collection)EasyList.build((Object)this.getUserKey()), projectRole, project, "atlassian-user-role-actor", (ErrorCollection)this);
        }
    }

    private String getUserKey() {
        ApplicationUser userObject = this.getUserManager().getUserByName(this.name);
        if (userObject == null) {
            return null;
        }
        return userObject.getKey();
    }
}

